/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class BinaryOperationExpressionConverter
implements SQLSegmentConverter<BinaryOperationExpression, SqlNode> {
    private static final Map<String, SqlOperator> REGISTRY = new TreeMap<String, SqlOperator>(String.CASE_INSENSITIVE_ORDER);

    private static void register() {
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.EQUALS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.GREATER_THAN);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LESS_THAN);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.OR);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.AND);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.PLUS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MINUS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MULTIPLY);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.DIVIDE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LIKE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.NOT_LIKE);
    }

    private static void register(SqlOperator sqlOperator) {
        REGISTRY.put(sqlOperator.getName(), sqlOperator);
    }

    private static void registerAlias() {
        REGISTRY.put("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        REGISTRY.put("~", (SqlOperator)SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE);
        REGISTRY.put("~*", (SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE);
        REGISTRY.put("!~", (SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE);
        REGISTRY.put("!~*", (SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE);
    }

    @Override
    public Optional<SqlNode> convert(BinaryOperationExpression segment) {
        SqlOperator operator = this.convertOperator(segment.getOperator());
        List<SqlNode> sqlNodes = this.convertSqlNodes(segment);
        return Optional.of(new SqlBasicCall(operator, sqlNodes, SqlParserPos.ZERO));
    }

    private List<SqlNode> convertSqlNodes(BinaryOperationExpression segment) {
        SqlNode left = new ExpressionConverter().convert(segment.getLeft()).orElseThrow(IllegalStateException::new);
        SqlNode right = new ExpressionConverter().convert(segment.getRight()).orElseThrow(IllegalStateException::new);
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        result.add(left);
        result.addAll(right instanceof SqlNodeList ? ((SqlNodeList)right).getList() : Collections.singletonList(right));
        return result;
    }

    private SqlOperator convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    static {
        BinaryOperationExpressionConverter.register();
        BinaryOperationExpressionConverter.registerAlias();
    }
}

