/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.TableToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class TableTokenGenerator
implements CollectionSQLTokenGenerator,
ShardingRuleAware {
    private ShardingRule shardingRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return true;
    }

    public Collection<TableToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof TableAvailable ? this.generateSQLTokens((TableAvailable)sqlStatementContext) : Collections.emptyList();
    }

    private Collection<TableToken> generateSQLTokens(TableAvailable sqlStatementContext) {
        LinkedList<TableToken> result = new LinkedList<TableToken>();
        for (SimpleTableSegment each : sqlStatementContext.getAllTables()) {
            if (!this.shardingRule.findTableRule(each.getTableName().getIdentifier().getValue()).isPresent()) continue;
            result.add(new TableToken(each.getStartIndex(), each.getTableName().getStopIndex(), each, (SQLStatementContext)sqlStatementContext, this.shardingRule));
        }
        return result;
    }

    @Generated
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

