/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.orderby;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.executor.sql.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.stream.StreamMergedResult;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sharding.merge.dql.orderby.OrderByValue;

public class OrderByStreamMergedResult
extends StreamMergedResult {
    private final Collection<OrderByItem> orderByItems;
    private final Queue<OrderByValue> orderByValuesQueue;
    private boolean isFirstNext;

    public OrderByStreamMergedResult(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, PhysicalSchemaMetaData schemaMetaData) throws SQLException {
        this.orderByItems = selectStatementContext.getOrderByContext().getItems();
        this.orderByValuesQueue = new PriorityQueue<OrderByValue>(queryResults.size());
        this.orderResultSetsToQueue(queryResults, selectStatementContext, schemaMetaData);
        this.isFirstNext = true;
    }

    private void orderResultSetsToQueue(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, PhysicalSchemaMetaData schemaMetaData) throws SQLException {
        for (QueryResult each : queryResults) {
            OrderByValue orderByValue = new OrderByValue(each, this.orderByItems, selectStatementContext, schemaMetaData);
            if (!orderByValue.next()) continue;
            this.orderByValuesQueue.offer(orderByValue);
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.isEmpty() ? queryResults.get(0) : this.orderByValuesQueue.peek().getQueryResult());
    }

    public boolean next() throws SQLException {
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        OrderByValue firstOrderByValue = this.orderByValuesQueue.poll();
        if (firstOrderByValue.next()) {
            this.orderByValuesQueue.offer(firstOrderByValue);
        }
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.peek().getQueryResult());
        return true;
    }

    @Generated
    protected Queue<OrderByValue> getOrderByValuesQueue() {
        return this.orderByValuesQueue;
    }

    @Generated
    protected boolean isFirstNext() {
        return this.isFirstNext;
    }
}

