/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableRuleStatement;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class AlterShardingTableRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterShardingTableRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, AlterShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException("Sharding", shardingSphereMetaData.getName()));
        ShardingTableRuleStatementChecker.checkAlteration(shardingSphereMetaData, sqlStatement.getRules(), currentRuleConfig);
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(AlterShardingTableRuleStatement sqlStatement) {
        return ShardingTableRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        this.removeRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
        this.addRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
    }

    private void removeRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        this.removeTableRule(currentRuleConfig, toBeAlteredRuleConfig);
        this.removeAutoTableRule(currentRuleConfig, toBeAlteredRuleConfig);
    }

    private void removeTableRule(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Map<String, ShardingTableRuleConfiguration> tableMap = currentRuleConfig.getTables().stream().collect(Collectors.toMap(ShardingTableRuleConfiguration::getLogicTable, each -> each));
        toBeAlteredRuleConfig.getTables().forEach(each -> {
            ShardingTableRuleConfiguration toBeAlteredConfiguration = (ShardingTableRuleConfiguration)tableMap.get(each.getLogicTable());
            currentRuleConfig.getTables().remove(toBeAlteredConfiguration);
        });
    }

    private void removeAutoTableRule(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Map<String, ShardingAutoTableRuleConfiguration> autoTableMap = currentRuleConfig.getAutoTables().stream().collect(Collectors.toMap(ShardingAutoTableRuleConfiguration::getLogicTable, each -> each));
        toBeAlteredRuleConfig.getAutoTables().forEach(each -> {
            ShardingAutoTableRuleConfiguration toBeAlteredConfiguration = (ShardingAutoTableRuleConfiguration)autoTableMap.get(each.getLogicTable());
            currentRuleConfig.getAutoTables().remove(toBeAlteredConfiguration);
        });
    }

    private void addRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getTables().addAll(toBeAlteredRuleConfig.getTables());
        currentRuleConfig.getAutoTables().addAll(toBeAlteredRuleConfig.getAutoTables());
        currentRuleConfig.getShardingAlgorithms().putAll(toBeAlteredRuleConfig.getShardingAlgorithms());
        currentRuleConfig.getKeyGenerators().putAll(toBeAlteredRuleConfig.getKeyGenerators());
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return AlterShardingTableRuleStatement.class.getCanonicalName();
    }

    static {
        ShardingSphereServiceLoader.register(ShardingAlgorithm.class);
        ShardingSphereServiceLoader.register(KeyGenerateAlgorithm.class);
    }
}

