/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import me.ahoo.cosid.sharding.LocalDateTimeConvertor;
import me.ahoo.cosid.sharding.StandardLocalDateTimeConvertor;
import org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval.AbstractCosIdIntervalShardingAlgorithm;

public final class CosIdIntervalShardingAlgorithm
extends AbstractCosIdIntervalShardingAlgorithm<Comparable<?>> {
    private static final String ZONE_ID_KEY = "zone-id";
    private static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private static final String TIMESTAMP_SECOND_UNIT = "SECOND";
    private static final String TIMESTAMP_UNIT_KEY = "ts-unit";

    @Override
    protected LocalDateTimeConvertor createLocalDateTimeConvertor(Properties props) {
        ZoneId zoneId = props.containsKey(ZONE_ID_KEY) ? ZoneId.of(props.getProperty(ZONE_ID_KEY)) : ZoneId.systemDefault();
        boolean isSecondTs = props.containsKey(TIMESTAMP_UNIT_KEY) && TIMESTAMP_SECOND_UNIT.equalsIgnoreCase(props.getProperty(TIMESTAMP_UNIT_KEY));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(props.getProperty(DATE_TIME_PATTERN_KEY, "yyyy-MM-dd HH:mm:ss"));
        return new StandardLocalDateTimeConvertor(zoneId, isSecondTs, dateTimeFormatter);
    }

    public String getType() {
        return "COSID_INTERVAL";
    }
}

