/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Properties;
import me.ahoo.cosid.sharding.IntervalStep;
import me.ahoo.cosid.sharding.IntervalTimeline;
import me.ahoo.cosid.sharding.LocalDateTimeConvertor;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.ShardingPluginException;

public abstract class AbstractCosIdIntervalShardingAlgorithm<T extends Comparable<?>>
implements StandardShardingAlgorithm<T> {
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    public static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    public static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    public static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    public static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    private IntervalTimeline intervalTimeline;
    private LocalDateTimeConvertor localDateTimeConvertor;

    public void init(Properties props) {
        this.intervalTimeline = this.createIntervalTimeline(props);
        this.localDateTimeConvertor = this.createLocalDateTimeConvertor(props);
    }

    private IntervalTimeline createIntervalTimeline(Properties props) {
        String logicNamePrefix = this.getRequiredValue(props, "logic-name-prefix");
        LocalDateTime effectiveLower = LocalDateTime.parse(this.getRequiredValue(props, DATE_TIME_LOWER_KEY), DEFAULT_DATE_TIME_FORMATTER);
        LocalDateTime effectiveUpper = LocalDateTime.parse(this.getRequiredValue(props, DATE_TIME_UPPER_KEY), DEFAULT_DATE_TIME_FORMATTER);
        ChronoUnit stepUnit = ChronoUnit.valueOf(this.getRequiredValue(props, INTERVAL_UNIT_KEY));
        int stepAmount = Integer.parseInt(props.getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        DateTimeFormatter suffixFormatter = DateTimeFormatter.ofPattern(this.getRequiredValue(props, SHARDING_SUFFIX_FORMAT_KEY));
        return new IntervalTimeline(logicNamePrefix, Range.closed((Comparable)effectiveLower, (Comparable)effectiveUpper), IntervalStep.of((ChronoUnit)stepUnit, (int)stepAmount), suffixFormatter);
    }

    private String getRequiredValue(Properties props, String key) {
        ShardingSpherePreconditions.checkState((boolean)props.containsKey(key), () -> new ShardingPluginException("%s can not be null.", new Object[]{key}));
        return props.getProperty(key);
    }

    protected abstract LocalDateTimeConvertor createLocalDateTimeConvertor(Properties var1);

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        return this.intervalTimeline.sharding(this.localDateTimeConvertor.toLocalDateTime((Comparable)shardingValue.getValue()));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        return this.intervalTimeline.sharding(this.toLocalDateTimeRange(shardingValue.getValueRange()));
    }

    private Range<LocalDateTime> toLocalDateTimeRange(Range<T> shardingValue) {
        Comparable endpointValue;
        if (Range.all().equals(shardingValue)) {
            return Range.all();
        }
        Comparable comparable = endpointValue = shardingValue.hasLowerBound() ? shardingValue.lowerEndpoint() : shardingValue.upperEndpoint();
        if (endpointValue instanceof LocalDateTime) {
            return shardingValue;
        }
        if (shardingValue.hasLowerBound() && shardingValue.hasUpperBound()) {
            LocalDateTime lower = this.localDateTimeConvertor.toLocalDateTime(shardingValue.lowerEndpoint());
            LocalDateTime upper = this.localDateTimeConvertor.toLocalDateTime(shardingValue.upperEndpoint());
            return Range.range((Comparable)lower, (BoundType)shardingValue.lowerBoundType(), (Comparable)upper, (BoundType)shardingValue.upperBoundType());
        }
        if (shardingValue.hasLowerBound()) {
            LocalDateTime lower = this.localDateTimeConvertor.toLocalDateTime(shardingValue.lowerEndpoint());
            return BoundType.OPEN == shardingValue.lowerBoundType() ? Range.greaterThan((Comparable)lower) : Range.atLeast((Comparable)lower);
        }
        LocalDateTime upper = this.localDateTimeConvertor.toLocalDateTime(shardingValue.upperEndpoint());
        return BoundType.OPEN == shardingValue.upperBoundType() ? Range.lessThan((Comparable)upper) : Range.atMost((Comparable)upper);
    }
}

