/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.sharding.api.config.strategy.sharding;

import com.google.common.base.Preconditions;
import lombok.Getter;

/**
 * Standard strategy configuration.
 */
@Getter
public final class StandardShardingStrategyConfiguration implements ShardingStrategyConfiguration {
    
    private final String shardingColumn;
    
    private final String shardingAlgorithmName;
    
    public StandardShardingStrategyConfiguration(final String shardingColumn, final String shardingAlgorithmName) {
        Preconditions.checkNotNull(shardingAlgorithmName, "Sharding algorithm name is required.");
        this.shardingColumn = shardingColumn;
        this.shardingAlgorithmName = shardingAlgorithmName;
    }
    
    @Override
    public String getType() {
        return "STANDARD";
    }
}
