/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.spring.boot;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.shadow.spring.boot.algorithm.ShadowAlgorithmProvidedBeanRegistry;
import org.apache.shardingsphere.shadow.spring.boot.condition.ShadowSpringBootCondition;
import org.apache.shardingsphere.shadow.spring.boot.rule.YamlShadowRuleSpringBootConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.swapper.ShadowRuleAlgorithmProviderConfigurationYamlSwapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={YamlShadowRuleSpringBootConfiguration.class})
@ConditionalOnClass(value={YamlShadowRuleConfiguration.class})
@Conditional(value={ShadowSpringBootCondition.class})
public class ShadowRuleSpringBootConfiguration {
    private final ShadowRuleAlgorithmProviderConfigurationYamlSwapper swapper = new ShadowRuleAlgorithmProviderConfigurationYamlSwapper();
    private final YamlShadowRuleSpringBootConfiguration yamlConfig;

    @Bean
    public RuleConfiguration shadowRuleConfiguration(ObjectProvider<Map<String, ShadowAlgorithm>> shadowAlgorithms) {
        AlgorithmProvidedShadowRuleConfiguration result = this.swapper.swapToObject(this.yamlConfig.getShadow());
        result.setShadowAlgorithms(this.createShadowAlgorithmMap(shadowAlgorithms));
        return result;
    }

    private Map<String, ShadowAlgorithm> createShadowAlgorithmMap(ObjectProvider<Map<String, ShadowAlgorithm>> shadowAlgorithms) {
        return Optional.ofNullable(shadowAlgorithms.getIfAvailable()).orElse(Collections.emptyMap());
    }

    @Bean
    public static ShadowAlgorithmProvidedBeanRegistry shadowAlgorithmProvidedBeanRegistry(Environment environment) {
        return new ShadowAlgorithmProvidedBeanRegistry(environment);
    }

    @Generated
    public ShadowRuleSpringBootConfiguration(YamlShadowRuleSpringBootConfiguration yamlConfig) {
        this.yamlConfig = yamlConfig;
    }
}

