/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.shadow.rewrite.token.generator.BaseShadowSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class ShadowPredicateColumnTokenGenerator
extends BaseShadowSQLTokenGenerator
implements CollectionSQLTokenGenerator {
    @Override
    protected boolean isGenerateSQLTokenForShadow(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Preconditions.checkState((boolean)((WhereAvailable)sqlStatementContext).getWhere().isPresent());
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        ExpressionSegment expression = ((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get()).getExpr();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(expression);
        LinkedList andPredicates = new LinkedList(expressionBuilder.extractAndPredicates().getAndPredicates());
        for (AndPredicate each : andPredicates) {
            result.addAll(this.generateSQLTokens((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get(), each));
        }
        return result;
    }

    private Collection<SQLToken> generateSQLTokens(WhereSegment whereSegment, AndPredicate andPredicate) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        LinkedList predicates = (LinkedList)andPredicate.getPredicates();
        for (int i = 0; i < predicates.size(); ++i) {
            ExpressionSegment expression = (ExpressionSegment)predicates.get(i);
            Optional column = ColumnExtractor.extract((ExpressionSegment)expression);
            if (!column.isPresent() || !this.getShadowRule().getColumn().equals(((ColumnSegment)column.get()).getIdentifier().getValue())) continue;
            if (1 == predicates.size()) {
                int startIndex = whereSegment.getStartIndex();
                int stopIndex = whereSegment.getStopIndex();
                result.add((SQLToken)new RemoveToken(startIndex, stopIndex));
                return result;
            }
            if (i == 0) {
                int startIndex = ((ExpressionSegment)predicates.get(0)).getStartIndex();
                int stopIndex = ((ExpressionSegment)predicates.get(i + 1)).getStartIndex() - 1;
                result.add((SQLToken)new RemoveToken(startIndex, stopIndex));
                return result;
            }
            int startIndex = ((ExpressionSegment)predicates.get(i - 1)).getStopIndex() + 1;
            int stopIndex = ((ExpressionSegment)predicates.get(i)).getStopIndex();
            result.add((SQLToken)new RemoveToken(startIndex, stopIndex));
            return result;
        }
        return result;
    }
}

