/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.InsertValuesToken;
import org.apache.shardingsphere.shadow.rewrite.token.generator.BaseShadowSQLTokenGenerator;
import org.apache.shardingsphere.shadow.rewrite.token.pojo.ShadowInsertValuesToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class ShadowInsertValuesTokenGenerator
extends BaseShadowSQLTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
PreviousSQLTokensAware {
    private List<SQLToken> previousSQLTokens;

    @Override
    protected boolean isGenerateSQLTokenForShadow(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatementContext)sqlStatementContext).getInsertColumnNames().contains(this.getShadowRule().getColumn());
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional<SQLToken> insertValuesToken = this.findPreviousSQLToken(InsertValuesToken.class);
        if (insertValuesToken.isPresent()) {
            this.processPreviousSQLToken(insertStatementContext, (InsertValuesToken)insertValuesToken.get());
            return (InsertValuesToken)insertValuesToken.get();
        }
        return this.generateNewSQLToken(insertStatementContext);
    }

    private void processPreviousSQLToken(InsertStatementContext insertStatementContext, InsertValuesToken insertValuesToken) {
        for (InsertValue insertValueToken : insertValuesToken.getInsertValues()) {
            Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
            while (descendingColumnNames.hasNext()) {
                String columnName = (String)descendingColumnNames.next();
                if (!this.getShadowRule().getColumn().equals(columnName)) continue;
                this.removeValueToken(insertValueToken, insertStatementContext, columnName);
            }
        }
    }

    private InsertValuesToken generateNewSQLToken(InsertStatementContext insertStatementContext) {
        Collection insertValuesSegments = ((InsertStatement)insertStatementContext.getSqlStatement()).getValues();
        ShadowInsertValuesToken result = new ShadowInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = new InsertValue(each.getValueExpressions());
            Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
            while (descendingColumnNames.hasNext()) {
                String columnName = (String)descendingColumnNames.next();
                if (!this.getShadowRule().getColumn().equals(columnName)) continue;
                this.removeValueToken(insertValueToken, insertStatementContext, columnName);
            }
            result.getInsertValues().add(insertValueToken);
        }
        return result;
    }

    private Optional<SQLToken> findPreviousSQLToken(Class<?> sqlToken) {
        for (SQLToken each : this.previousSQLTokens) {
            if (!sqlToken.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private void removeValueToken(InsertValue insertValueToken, InsertStatementContext insertStatementContext, String columnName) {
        int columnIndex = insertStatementContext.getColumnNames().indexOf(columnName);
        insertValueToken.getValues().remove(columnIndex);
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

