/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.shadow.rewrite.token.generator.BaseShadowSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class RemoveShadowColumnTokenGenerator
extends BaseShadowSQLTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext> {
    @Override
    protected boolean isGenerateSQLTokenForShadow(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof InsertStatementContext)) {
            return false;
        }
        Optional insertColumnsSegment = ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getInsertColumns();
        return insertColumnsSegment.isPresent() && !((InsertColumnsSegment)insertColumnsSegment.get()).getColumns().isEmpty();
    }

    public Collection<RemoveToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        Optional sqlSegment = ((InsertStatement)insertStatementContext.getSqlStatement()).getInsertColumns();
        Preconditions.checkState((boolean)sqlSegment.isPresent());
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        LinkedList columns = (LinkedList)((InsertColumnsSegment)sqlSegment.get()).getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!this.getShadowRule().getColumn().equals(((ColumnSegment)columns.get(i)).getIdentifier().getValue())) continue;
            if (i == 0) {
                result.add(new RemoveToken(((ColumnSegment)columns.get(0)).getStartIndex(), ((ColumnSegment)columns.get(i + 1)).getStartIndex() - 1));
                continue;
            }
            result.add(new RemoveToken(((ColumnSegment)columns.get(i - 1)).getStopIndex() + 1, ((ColumnSegment)columns.get(i)).getStopIndex()));
        }
        return result;
    }
}

