/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.rewrite;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.underlying.route.context.RouteContext;

public final class SQLRewriteEntry {
    private final SchemaMetaData schemaMetaData;
    private final ConfigurationProperties properties;
    private final Map<BaseRule, SQLRewriteContextDecorator> decorators = new LinkedHashMap<BaseRule, SQLRewriteContextDecorator>();

    public void registerDecorator(BaseRule rule, SQLRewriteContextDecorator decorator) {
        this.decorators.put(rule, decorator);
    }

    public SQLRewriteContext createSQLRewriteContext(String sql, List<Object> parameters, SQLStatementContext sqlStatementContext, RouteContext routeContext) {
        SQLRewriteContext result = new SQLRewriteContext(this.schemaMetaData, sqlStatementContext, sql, parameters);
        this.decorate(this.decorators, result, routeContext);
        result.generateSQLTokens();
        return result;
    }

    private void decorate(Map<BaseRule, SQLRewriteContextDecorator> decorators, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        for (Map.Entry<BaseRule, SQLRewriteContextDecorator> entry : decorators.entrySet()) {
            BaseRule rule = entry.getKey();
            SQLRewriteContextDecorator decorator = entry.getValue();
            if (decorator instanceof RouteContextAware) {
                ((RouteContextAware)((Object)decorator)).setRouteContext(routeContext);
            }
            decorator.decorate(rule, this.properties, sqlRewriteContext);
        }
    }

    @Generated
    public SQLRewriteEntry(SchemaMetaData schemaMetaData, ConfigurationProperties properties) {
        this.schemaMetaData = schemaMetaData;
        this.properties = properties;
    }
}

