/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.provider;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.constant.ReadwriteSplittingDistSQLConstants;

public final class ReadwriteSplittingRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<ReadwriteSplittingRuleConfiguration> {
    public String convert(ReadwriteSplittingRuleConfiguration ruleConfig) {
        if (ruleConfig.getDataSources().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder("CREATE READWRITE_SPLITTING RULE");
        Iterator iterator = ruleConfig.getDataSources().iterator();
        while (iterator.hasNext()) {
            this.appendStaticReadWriteSplittingRule(ruleConfig.getLoadBalancers(), (ReadwriteSplittingDataSourceRuleConfiguration)iterator.next(), result);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";");
        return result.toString();
    }

    private void appendStaticReadWriteSplittingRule(Map<String, AlgorithmConfiguration> loadBalancers, ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, StringBuilder stringBuilder) {
        String readDataSourceNames = this.getReadDataSourceNames(dataSourceRuleConfig.getReadDataSourceNames());
        String transactionalReadQueryStrategy = dataSourceRuleConfig.getTransactionalReadQueryStrategy().name();
        String loadBalancerType = this.getLoadBalancerType(loadBalancers.get(dataSourceRuleConfig.getLoadBalancerName()));
        stringBuilder.append(String.format(ReadwriteSplittingDistSQLConstants.READWRITE_SPLITTING_FOR_STATIC, dataSourceRuleConfig.getName(), dataSourceRuleConfig.getWriteDataSourceName(), readDataSourceNames, transactionalReadQueryStrategy, loadBalancerType));
    }

    private String getReadDataSourceNames(Collection<String> readDataSourceNames) {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = readDataSourceNames.iterator();
        while (iterator.hasNext()) {
            result.append(String.format("%s", iterator.next()));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private String getLoadBalancerType(AlgorithmConfiguration algorithmConfig) {
        StringBuilder result = new StringBuilder();
        String loadBalancerType = AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)algorithmConfig);
        if (!Strings.isNullOrEmpty((String)loadBalancerType)) {
            result.append(",").append(System.lineSeparator()).append(loadBalancerType);
        }
        return result.toString();
    }

    public Class<ReadwriteSplittingRuleConfiguration> getType() {
        return ReadwriteSplittingRuleConfiguration.class;
    }
}

