/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.checker.ReadwriteSplittingRuleStatementChecker;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.DropReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class DropReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isIfExists()) {
            return;
        }
        String databaseName = database.getName();
        ReadwriteSplittingRuleStatementChecker.checkRuleConfigurationExist(database, currentRuleConfig);
        this.checkToBeDroppedRuleNames(databaseName, sqlStatement, currentRuleConfig);
        this.checkToBeDroppedInUsed(database, sqlStatement);
    }

    private void checkToBeDroppedRuleNames(String databaseName, DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedRuleNames.isEmpty(), () -> new MissingRequiredRuleException("Readwrite-splitting", databaseName, sqlStatement.getNames()));
    }

    private void checkToBeDroppedInUsed(ShardingSphereDatabase database, DropReadwriteSplittingRuleStatement sqlStatement) {
        Collection<String> resourceBeUsed = this.getInUsedResources(database);
        Collection ruleInUsed = sqlStatement.getNames().stream().filter(resourceBeUsed::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)ruleInUsed.isEmpty(), () -> new RuleInUsedException("Readwrite-splitting", database.getName(), ruleInUsed));
    }

    private Collection<String> getInUsedResources(ShardingSphereDatabase database) {
        HashSet<String> result = new HashSet<String>();
        for (DataSourceContainedRule each : database.getRuleMetaData().findRules(DataSourceContainedRule.class)) {
            if (each instanceof ReadwriteSplittingRule) continue;
            HashSet actualDataSources = new HashSet();
            each.getDataSourceMapper().values().forEach(actualDataSources::addAll);
            result.addAll(actualDataSources);
        }
        for (DataSourceContainedRule each : database.getRuleMetaData().findRules(DataNodeContainedRule.class)) {
            if (each instanceof SingleRule) continue;
            HashSet actualDataNodes = new HashSet();
            each.getAllDataNodes().values().forEach(actualDataNodes::addAll);
            result.addAll(actualDataNodes.stream().map(DataNode::getDataSourceName).collect(Collectors.toSet()));
        }
        return result;
    }

    public ReadwriteSplittingRuleConfiguration buildToBeDroppedRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, DropReadwriteSplittingRuleStatement sqlStatement) {
        LinkedList<ReadwriteSplittingDataSourceRuleConfiguration> toBeDroppedDataSources = new LinkedList<ReadwriteSplittingDataSourceRuleConfiguration>();
        HashMap toBeDroppedLoadBalancers = new HashMap();
        for (String each2 : sqlStatement.getNames()) {
            toBeDroppedDataSources.add(new ReadwriteSplittingDataSourceRuleConfiguration(each2, null, null, null));
            this.dropRule(currentRuleConfig, each2);
        }
        DropReadwriteSplittingRuleStatementUpdater.findUnusedLoadBalancers(currentRuleConfig).forEach(each -> toBeDroppedLoadBalancers.put(each, (AlgorithmConfiguration)currentRuleConfig.getLoadBalancers().get(each)));
        return new ReadwriteSplittingRuleConfiguration(toBeDroppedDataSources, toBeDroppedLoadBalancers);
    }

    public boolean updateCurrentRuleConfiguration(DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        this.dropUnusedLoadBalancer(currentRuleConfig);
        return currentRuleConfig.isEmpty();
    }

    private void dropRule(ReadwriteSplittingRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<ReadwriteSplittingDataSourceRuleConfiguration> dataSourceRuleConfig = currentRuleConfig.getDataSources().stream().filter(each -> ruleName.equals(each.getName())).findAny();
        dataSourceRuleConfig.ifPresent(optional -> currentRuleConfig.getDataSources().remove(optional));
    }

    private void dropUnusedLoadBalancer(ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        DropReadwriteSplittingRuleStatementUpdater.findUnusedLoadBalancers(currentRuleConfig).forEach(each -> currentRuleConfig.getLoadBalancers().remove(each));
    }

    private static Collection<String> findUnusedLoadBalancers(ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        Collection inUsedAlgorithms = currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getLoadBalancerName).collect(Collectors.toSet());
        return currentRuleConfig.getLoadBalancers().keySet().stream().filter(each -> !inUsedAlgorithms.contains(each)).collect(Collectors.toSet());
    }

    public boolean hasAnyOneToBeDropped(DropReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toSet()), sqlStatement.getNames()).isEmpty();
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public Class<DropReadwriteSplittingRuleStatement> getType() {
        return DropReadwriteSplittingRuleStatement.class;
    }
}

