/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.props.PropertiesConverter;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class ShowReadwriteSplittingRuleExecutor
implements RQLExecutor<ShowReadwriteSplittingRulesStatement> {
    private Map<String, Map<String, String>> exportableDataSourceMap = Collections.emptyMap();

    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowReadwriteSplittingRulesStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class);
        Collection<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        if (rule.isPresent()) {
            this.buildExportableMap((ReadwriteSplittingRule)rule.get());
            result = this.buildData((ReadwriteSplittingRule)rule.get(), sqlStatement);
        }
        return result;
    }

    private void buildExportableMap(ReadwriteSplittingRule rule) {
        Map exportedData = rule.getExportData();
        this.exportableDataSourceMap = (Map)exportedData.get("static_readwrite_splitting_rules");
    }

    private Collection<LocalDataQueryResultRow> buildData(ReadwriteSplittingRule rule, ShowReadwriteSplittingRulesStatement sqlStatement) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        ReadwriteSplittingRuleConfiguration ruleConfig = (ReadwriteSplittingRuleConfiguration)rule.getConfiguration();
        ruleConfig.getDataSources().forEach(each -> {
            LocalDataQueryResultRow dataItem = this.buildDataItem((ReadwriteSplittingDataSourceRuleConfiguration)each, this.getLoadBalancers(ruleConfig));
            if (null == sqlStatement.getRuleName() || sqlStatement.getRuleName().equalsIgnoreCase(each.getName())) {
                result.add(dataItem);
            }
        });
        return result;
    }

    private LocalDataQueryResultRow buildDataItem(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, AlgorithmConfiguration> loadBalancers) {
        String name = dataSourceRuleConfig.getName();
        Map<String, String> exportDataSources = this.exportableDataSourceMap.get(name);
        Optional<AlgorithmConfiguration> loadBalancer = Optional.ofNullable(loadBalancers.get(dataSourceRuleConfig.getLoadBalancerName()));
        return new LocalDataQueryResultRow(new Object[]{name, this.getWriteDataSourceName(dataSourceRuleConfig, exportDataSources), this.getReadDataSourceNames(dataSourceRuleConfig, exportDataSources), dataSourceRuleConfig.getTransactionalReadQueryStrategy().name(), loadBalancer.map(AlgorithmConfiguration::getType).orElse(""), loadBalancer.map(each -> PropertiesConverter.convert((Properties)each.getProps())).orElse("")});
    }

    private Map<String, AlgorithmConfiguration> getLoadBalancers(ReadwriteSplittingRuleConfiguration ruleConfig) {
        Map loadBalancers = ruleConfig.getLoadBalancers();
        return null == loadBalancers ? Collections.emptyMap() : loadBalancers;
    }

    private String getWriteDataSourceName(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, String> exportDataSources) {
        return null == exportDataSources ? dataSourceRuleConfig.getWriteDataSourceName() : exportDataSources.get("primary_data_source_name");
    }

    private String getReadDataSourceNames(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, String> exportDataSources) {
        return null == exportDataSources ? Joiner.on((String)",").join((Iterable)dataSourceRuleConfig.getReadDataSourceNames()) : exportDataSources.get("replica_data_source_names");
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "write_storage_unit_name", "read_storage_unit_names", "transactional_read_query_strategy", "load_balancer_type", "load_balancer_props");
    }

    public Class<ShowReadwriteSplittingRulesStatement> getType() {
        return ShowReadwriteSplittingRulesStatement.class;
    }
}

