/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.arguments.BootstrapArguments;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfigurationLoader;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.frontend.CDCServer;
import org.apache.shardingsphere.proxy.frontend.ShardingSphereProxy;
import org.apache.shardingsphere.proxy.frontend.ssl.ProxySSLContext;
import org.apache.shardingsphere.proxy.initializer.BootstrapInitializer;

public final class Bootstrap {
    public static void main(String[] args) throws IOException, SQLException {
        BootstrapArguments bootstrapArgs = new BootstrapArguments(args);
        YamlProxyConfiguration yamlConfig = ProxyConfigurationLoader.load((String)bootstrapArgs.getConfigurationPath());
        int port = bootstrapArgs.getPort().orElseGet(() -> (Integer)new ConfigurationProperties(yamlConfig.getServerConfiguration().getProps()).getValue((Enum)ConfigurationPropertyKey.PROXY_DEFAULT_PORT));
        List<String> addresses = bootstrapArgs.getAddresses();
        new BootstrapInitializer().init(yamlConfig, port, bootstrapArgs.isForce());
        Optional.ofNullable((Integer)yamlConfig.getServerConfiguration().getProps().get(ConfigurationPropertyKey.CDC_SERVER_PORT.getKey())).ifPresent(optional -> new CDCServer(addresses, optional.intValue()).start());
        ProxySSLContext.init();
        ShardingSphereProxy proxy = new ShardingSphereProxy();
        bootstrapArgs.getSocketPath().ifPresent(arg_0 -> ((ShardingSphereProxy)proxy).start(arg_0));
        proxy.start(port, addresses);
    }

    @Generated
    private Bootstrap() {
    }
}

