/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dialect.postgresql.exception;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.exception.external.sql.vendor.VendorError;

public final class PostgreSQLException
extends SQLException {
    private static final long serialVersionUID = -593592349806424431L;
    private final ServerErrorMessage serverErrorMessage;

    public PostgreSQLException(String msg, String state) {
        super(msg, state);
        this.serverErrorMessage = null;
    }

    public PostgreSQLException(ServerErrorMessage serverErrorMessage) {
        super(serverErrorMessage.toString(), serverErrorMessage.getSqlState());
        this.serverErrorMessage = serverErrorMessage;
    }

    @Generated
    public ServerErrorMessage getServerErrorMessage() {
        return this.serverErrorMessage;
    }

    public static class ServerErrorMessage
    implements Serializable {
        private static final long serialVersionUID = -2823942573556507523L;
        private final String severity;
        private final String sqlState;
        private final String message;

        public ServerErrorMessage(String severity, VendorError vendorError, Object ... reasonArgs) {
            this.severity = severity;
            this.sqlState = vendorError.getSqlState().getValue();
            this.message = String.format(vendorError.getReason(), reasonArgs);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (null != this.severity) {
                result.append(this.severity).append(": ");
            }
            if (null != this.message) {
                result.append(this.message);
            }
            if (null != this.sqlState) {
                result.append("\n  ").append(MessageFormat.format("Server SQLState: {0}", this.sqlState));
            }
            return result.toString();
        }

        @Generated
        public String getSeverity() {
            return this.severity;
        }

        @Generated
        public String getSqlState() {
            return this.sqlState;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

