/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.type;

import java.util.Collection;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.OpenGaussStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussAlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dcl.OpenGaussRevokeStatement;

public final class OpenGaussDCLStatementVisitor
extends OpenGaussStatementVisitor
implements DCLStatementVisitor {
    @Override
    public ASTNode visitGrant(OpenGaussStatementParser.GrantContext ctx) {
        OpenGaussGrantStatement result = new OpenGaussGrantStatement();
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(OpenGaussStatementParser.RevokeContext ctx) {
        OpenGaussRevokeStatement result = new OpenGaussRevokeStatement();
        if (this.containsTableSegment(ctx.privilegeClause())) {
            result.getTables().addAll(this.getTableSegments(ctx.privilegeClause()));
        }
        return result;
    }

    private boolean containsTableSegment(OpenGaussStatementParser.PrivilegeClauseContext ctx) {
        return null != ctx && null != ctx.onObjectClause() && null != ctx.onObjectClause().privilegeLevel() && null != ctx.onObjectClause().privilegeLevel().tableNames();
    }

    private Collection<SimpleTableSegment> getTableSegments(OpenGaussStatementParser.PrivilegeClauseContext ctx) {
        return ((CollectionValue)this.visit((ParseTree)ctx.onObjectClause().privilegeLevel().tableNames())).getValue();
    }

    @Override
    public ASTNode visitCreateUser(OpenGaussStatementParser.CreateUserContext ctx) {
        return new OpenGaussCreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(OpenGaussStatementParser.DropUserContext ctx) {
        return new OpenGaussDropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(OpenGaussStatementParser.AlterUserContext ctx) {
        return new OpenGaussAlterUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(OpenGaussStatementParser.CreateRoleContext ctx) {
        return new OpenGaussCreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(OpenGaussStatementParser.AlterRoleContext ctx) {
        return new OpenGaussAlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(OpenGaussStatementParser.DropRoleContext ctx) {
        return new OpenGaussDropRoleStatement();
    }
}

