/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.type;

import java.util.Collection;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.MySQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.FromSchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.FromTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.ShowLikeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLAlterResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLAnalyzeTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLBinlogStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLCacheIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLCheckTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLChecksumTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLCloneStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLCreateLoadableFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLCreateResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLDelimiterStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLDropResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLExplainStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLFlushStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLHelpStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLInstallComponentStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLInstallPluginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLKillStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLLoadIndexInfoStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLOptimizeTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLRepairTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLResetPersistStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLResetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLRestartStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLSetResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLSetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowBinaryLogsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowBinlogEventsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCharacterSetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCollationStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowEngineStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowErrorsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowEventsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowFunctionCodeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowGrantsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowMasterStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowOpenTablesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowOtherStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowPluginsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowPrivilegesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcedureCodeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProfileStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProfilesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowRelayLogEventsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowReplicaStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowReplicasStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowSlaveHostsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowSlaveStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTriggersStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowVariablesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowWarningsStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShutdownStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLUninstallComponentStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLUninstallPluginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLUseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.CacheTableIndexSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.CloneActionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.CloneInstanceSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.LoadTableIndexSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.PartitionDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.PartitionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.ResetMasterOptionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.ResetOptionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.ResetSlaveOptionSegment;

public final class MySQLDALStatementVisitor
extends MySQLStatementVisitor
implements DALStatementVisitor {
    @Override
    public ASTNode visitUninstallPlugin(MySQLStatementParser.UninstallPluginContext ctx) {
        MySQLUninstallPluginStatement result = new MySQLUninstallPluginStatement();
        result.setPluginName(((IdentifierValue)this.visit((ParseTree)ctx.pluginName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitShowCreateDatabase(MySQLStatementParser.ShowCreateDatabaseContext ctx) {
        MySQLShowCreateDatabaseStatement result = new MySQLShowCreateDatabaseStatement();
        result.setDatabaseName(((DatabaseSegment)this.visit((ParseTree)ctx.schemaName())).getIdentifier().getValue());
        return result;
    }

    @Override
    public ASTNode visitShowBinaryLogs(MySQLStatementParser.ShowBinaryLogsContext ctx) {
        return new MySQLShowBinaryLogsStatement();
    }

    @Override
    public ASTNode visitShowStatus(MySQLStatementParser.ShowStatusContext ctx) {
        MySQLShowStatusStatement result = new MySQLShowStatusStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCreateView(MySQLStatementParser.ShowCreateViewContext ctx) {
        return new MySQLShowCreateViewStatement();
    }

    @Override
    public ASTNode visitShowEngines(MySQLStatementParser.ShowEnginesContext ctx) {
        return new MySQLShowOtherStatement();
    }

    @Override
    public ASTNode visitShowEngine(MySQLStatementParser.ShowEngineContext ctx) {
        MySQLShowEngineStatement result = new MySQLShowEngineStatement();
        result.setEngineName(ctx.engineRef().getText());
        return result;
    }

    @Override
    public ASTNode visitShowCharset(MySQLStatementParser.ShowCharsetContext ctx) {
        return new MySQLShowOtherStatement();
    }

    @Override
    public ASTNode visitShowCreateEvent(MySQLStatementParser.ShowCreateEventContext ctx) {
        MySQLShowCreateEventStatement result = new MySQLShowCreateEventStatement();
        result.setEventName(((IdentifierValue)this.visit((ParseTree)ctx.eventName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitShowCreateFunction(MySQLStatementParser.ShowCreateFunctionContext ctx) {
        MySQLShowCreateFunctionStatement result = new MySQLShowCreateFunctionStatement();
        result.setFunctionName(((FunctionSegment)this.visit((ParseTree)ctx.functionName())).getFunctionName());
        return result;
    }

    @Override
    public ASTNode visitShowCreateProcedure(MySQLStatementParser.ShowCreateProcedureContext ctx) {
        MySQLShowCreateProcedureStatement result = new MySQLShowCreateProcedureStatement();
        result.setProcedureName(((IdentifierValue)this.visit((ParseTree)ctx.procedureName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitShowBinlogEvents(MySQLStatementParser.ShowBinlogEventsContext ctx) {
        MySQLShowBinlogEventsStatement result = new MySQLShowBinlogEventsStatement();
        if (null != ctx.logName()) {
            result.setLogName(ctx.logName().getText());
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowErrors(MySQLStatementParser.ShowErrorsContext ctx) {
        MySQLShowErrorsStatement result = new MySQLShowErrorsStatement();
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowWarnings(MySQLStatementParser.ShowWarningsContext ctx) {
        MySQLShowWarningsStatement result = new MySQLShowWarningsStatement();
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitResetStatement(MySQLStatementParser.ResetStatementContext ctx) {
        MySQLStatementParser.ResetPersistContext persistContext = ctx.resetPersist();
        if (null != persistContext) {
            return (ASTNode)this.visit((ParseTree)persistContext);
        }
        MySQLResetStatement result = new MySQLResetStatement();
        for (MySQLStatementParser.ResetOptionContext each : ctx.resetOption()) {
            if (null == each.MASTER() && null == each.SLAVE()) continue;
            result.getOptions().add((ResetOptionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitResetPersist(MySQLStatementParser.ResetPersistContext ctx) {
        return new MySQLResetPersistStatement(null != ctx.ifExists(), null == ctx.identifier() ? null : new IdentifierValue(ctx.identifier().getText()));
    }

    @Override
    public ASTNode visitResetOption(MySQLStatementParser.ResetOptionContext ctx) {
        if (null != ctx.MASTER()) {
            ResetMasterOptionSegment result = new ResetMasterOptionSegment();
            if (null != ctx.binaryLogFileIndexNumber()) {
                result.setBinaryLogFileIndexNumber(Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.binaryLogFileIndexNumber())).getValue().longValue()));
            }
            result.setStartIndex(ctx.start.getStartIndex());
            result.setStopIndex(ctx.stop.getStopIndex());
            return result;
        }
        ResetSlaveOptionSegment result = new ResetSlaveOptionSegment();
        if (null != ctx.ALL()) {
            result.setAll(true);
        }
        if (null != ctx.channelOption()) {
            result.setChannelOption(((StringLiteralValue)this.visit((ParseTree)ctx.channelOption())).getValue());
        }
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        return result;
    }

    @Override
    public ASTNode visitChannelOption(MySQLStatementParser.ChannelOptionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.string_());
    }

    @Override
    public ASTNode visitBinaryLogFileIndexNumber(MySQLStatementParser.BinaryLogFileIndexNumberContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public ASTNode visitShowReplicas(MySQLStatementParser.ShowReplicasContext ctx) {
        return new MySQLShowReplicasStatement();
    }

    @Override
    public ASTNode visitRepairTable(MySQLStatementParser.RepairTableContext ctx) {
        MySQLRepairTableStatement result = new MySQLRepairTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitAnalyzeTable(MySQLStatementParser.AnalyzeTableContext ctx) {
        MySQLAnalyzeTableStatement result = new MySQLAnalyzeTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCacheIndex(MySQLStatementParser.CacheIndexContext ctx) {
        MySQLCacheIndexStatement result = new MySQLCacheIndexStatement();
        if (null != ctx.cacheTableIndexList()) {
            for (MySQLStatementParser.CacheTableIndexListContext each : ctx.cacheTableIndexList()) {
                result.getTableIndexes().add((CacheTableIndexSegment)this.visit((ParseTree)each));
            }
        }
        if (null != ctx.partitionList()) {
            SimpleTableSegment table = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            PartitionDefinitionSegment segment = new PartitionDefinitionSegment(ctx.tableName().getStart().getStartIndex(), ctx.partitionList().getStop().getStopIndex(), table);
            segment.getPartitions().addAll(((CollectionValue)this.visit((ParseTree)ctx.partitionList())).getValue());
            result.setPartitionDefinition(segment);
        }
        if (null != ctx.DEFAULT()) {
            result.setName(new IdentifierValue(ctx.DEFAULT().getText()));
        } else {
            result.setName((IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return result;
    }

    @Override
    public ASTNode visitCacheTableIndexList(MySQLStatementParser.CacheTableIndexListContext ctx) {
        CacheTableIndexSegment result = new CacheTableIndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        for (MySQLStatementParser.IndexNameContext each : ctx.indexName()) {
            result.getIndexes().add((IndexSegment)this.visitIndexName(each));
        }
        return result;
    }

    @Override
    public ASTNode visitPartitionList(MySQLStatementParser.PartitionListContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.PartitionNameContext each : ctx.partitionName()) {
            result.getValue().add((PartitionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitPartitionName(MySQLStatementParser.PartitionNameContext ctx) {
        return new PartitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitChecksumTable(MySQLStatementParser.ChecksumTableContext ctx) {
        MySQLChecksumTableStatement result = new MySQLChecksumTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitFlush(MySQLStatementParser.FlushContext ctx) {
        if (null != ctx.tablesOption()) {
            return (ASTNode)this.visit((ParseTree)ctx.tablesOption());
        }
        return new MySQLFlushStatement();
    }

    @Override
    public ASTNode visitTablesOption(MySQLStatementParser.TablesOptionContext ctx) {
        MySQLFlushStatement result = new MySQLFlushStatement();
        result.setFlushTable(true);
        for (MySQLStatementParser.TableNameContext each : ctx.tableName()) {
            result.getTables().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitKill(MySQLStatementParser.KillContext ctx) {
        MySQLKillStatement result = new MySQLKillStatement();
        if (null != ctx.AT_()) {
            result.setProcessId(ctx.AT_().getText().concat(ctx.IDENTIFIER_().getText()));
        } else {
            result.setProcessId(ctx.IDENTIFIER_().getText());
        }
        return result;
    }

    @Override
    public ASTNode visitLoadIndexInfo(MySQLStatementParser.LoadIndexInfoContext ctx) {
        MySQLLoadIndexInfoStatement result = new MySQLLoadIndexInfoStatement();
        for (MySQLStatementParser.LoadTableIndexListContext each : ctx.loadTableIndexList()) {
            result.getTableIndexes().add((LoadTableIndexSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitLoadTableIndexList(MySQLStatementParser.LoadTableIndexListContext ctx) {
        LoadTableIndexSegment result = new LoadTableIndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.indexName()) {
            for (MySQLStatementParser.IndexNameContext each : ctx.indexName()) {
                result.getIndexes().add((IndexSegment)this.visitIndexName(each));
            }
        }
        if (null != ctx.partitionList()) {
            result.getPartitions().addAll(((CollectionValue)this.visit((ParseTree)ctx.partitionList())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitInstallPlugin(MySQLStatementParser.InstallPluginContext ctx) {
        MySQLInstallPluginStatement result = new MySQLInstallPluginStatement();
        result.setPluginName(((IdentifierValue)this.visit((ParseTree)ctx.pluginName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitClone(MySQLStatementParser.CloneContext ctx) {
        MySQLCloneStatement result = new MySQLCloneStatement();
        result.setCloneActionSegment((CloneActionSegment)this.visit((ParseTree)ctx.cloneAction()));
        return result;
    }

    @Override
    public ASTNode visitCloneAction(MySQLStatementParser.CloneActionContext ctx) {
        CloneActionSegment result = new CloneActionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.cloneInstance()) {
            MySQLStatementParser.CloneInstanceContext cloneInstance = ctx.cloneInstance();
            CloneInstanceSegment cloneInstanceSegment = new CloneInstanceSegment(cloneInstance.start.getStartIndex(), cloneInstance.stop.getStopIndex());
            cloneInstanceSegment.setUsername(((StringLiteralValue)this.visitUsername(cloneInstance.username())).getValue());
            cloneInstanceSegment.setHostname(((StringLiteralValue)this.visit((ParseTree)cloneInstance.hostname())).getValue());
            cloneInstanceSegment.setPort(new NumberLiteralValue(cloneInstance.port().NUMBER_().getText()).getValue().intValue());
            cloneInstanceSegment.setPassword(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            if (null != ctx.SSL() && null == ctx.NO()) {
                cloneInstanceSegment.setSslRequired(true);
            }
            result.setCloneInstance(cloneInstanceSegment);
        }
        if (null != ctx.cloneDir()) {
            result.setCloneDir(((StringLiteralValue)this.visit((ParseTree)ctx.cloneDir())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitOptimizeTable(MySQLStatementParser.OptimizeTableContext ctx) {
        MySQLOptimizeTableStatement result = new MySQLOptimizeTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitUse(MySQLStatementParser.UseContext ctx) {
        MySQLUseStatement result = new MySQLUseStatement();
        result.setSchema(((DatabaseSegment)this.visit((ParseTree)ctx.schemaName())).getIdentifier().getValue());
        return result;
    }

    @Override
    public ASTNode visitExplain(MySQLStatementParser.ExplainContext ctx) {
        MySQLExplainStatement result = new MySQLExplainStatement();
        if (null != ctx.tableName()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
            if (null != ctx.columnRef()) {
                result.setColumnWild((ColumnSegment)this.visit((ParseTree)ctx.columnRef()));
            } else if (null != ctx.textString()) {
                result.setColumnWild((ColumnSegment)this.visit((ParseTree)ctx.textString()));
            }
        } else if (null != ctx.explainableStatement()) {
            result.setStatement((SQLStatement)this.visit((ParseTree)ctx.explainableStatement()));
        } else if (null != ctx.select()) {
            result.setStatement((SQLStatement)this.visit((ParseTree)ctx.select()));
        } else if (null != ctx.delete()) {
            result.setStatement((SQLStatement)this.visit((ParseTree)ctx.delete()));
        } else if (null != ctx.update()) {
            result.setStatement((SQLStatement)this.visit((ParseTree)ctx.update()));
        } else if (null != ctx.insert()) {
            result.setStatement((SQLStatement)this.visit((ParseTree)ctx.insert()));
        }
        return result;
    }

    @Override
    public ASTNode visitExplainableStatement(MySQLStatementParser.ExplainableStatementContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.replace()) {
            return (ASTNode)this.visit((ParseTree)ctx.replace());
        }
        return (ASTNode)this.visit((ParseTree)ctx.update());
    }

    @Override
    public ASTNode visitShowProcedureCode(MySQLStatementParser.ShowProcedureCodeContext ctx) {
        MySQLShowProcedureCodeStatement result = new MySQLShowProcedureCodeStatement();
        result.setFunction((FunctionSegment)this.visit((ParseTree)ctx.functionName()));
        return result;
    }

    @Override
    public ASTNode visitShowProfile(MySQLStatementParser.ShowProfileContext ctx) {
        MySQLShowProfileStatement result = new MySQLShowProfileStatement();
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowProfiles(MySQLStatementParser.ShowProfilesContext ctx) {
        return new MySQLShowProfilesStatement();
    }

    @Override
    public ASTNode visitShowDatabases(MySQLStatementParser.ShowDatabasesContext ctx) {
        MySQLShowDatabasesStatement result = new MySQLShowDatabasesStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowEvents(MySQLStatementParser.ShowEventsContext ctx) {
        MySQLShowEventsStatement result = new MySQLShowEventsStatement();
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowTables(MySQLStatementParser.ShowTablesContext ctx) {
        MySQLShowTablesStatement result = new MySQLShowTablesStatement();
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.setContainsFull(null != ctx.FULL());
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowTriggers(MySQLStatementParser.ShowTriggersContext ctx) {
        MySQLShowTriggersStatement result = new MySQLShowTriggersStatement();
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowWhereClause(MySQLStatementParser.ShowWhereClauseContext ctx) {
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public ASTNode visitShowTableStatus(MySQLStatementParser.ShowTableStatusContext ctx) {
        MySQLShowTableStatusStatement result = new MySQLShowTableStatusStatement();
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowColumns(MySQLStatementParser.ShowColumnsContext ctx) {
        MySQLShowColumnsStatement result = new MySQLShowColumnsStatement();
        if (null != ctx.fromTable()) {
            result.setTable(((FromTableSegment)this.visit((ParseTree)ctx.fromTable())).getTable());
        }
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFilter(MySQLStatementParser.ShowFilterContext ctx) {
        ShowFilterSegment result = new ShowFilterSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.showLike()) {
            result.setLike((ShowLikeSegment)this.visit((ParseTree)ctx.showLike()));
        }
        if (null != ctx.showWhereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.showWhereClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitShowIndex(MySQLStatementParser.ShowIndexContext ctx) {
        MySQLShowIndexStatement result = new MySQLShowIndexStatement();
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.fromTable()) {
            result.setTable(((FromTableSegment)this.visitFromTable(ctx.fromTable())).getTable());
        }
        return result;
    }

    @Override
    public ASTNode visitShowCreateTable(MySQLStatementParser.ShowCreateTableContext ctx) {
        MySQLShowCreateTableStatement result = new MySQLShowCreateTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitShowCreateTrigger(MySQLStatementParser.ShowCreateTriggerContext ctx) {
        MySQLShowCreateTriggerStatement result = new MySQLShowCreateTriggerStatement();
        result.setName(((IdentifierValue)this.visit((ParseTree)ctx.triggerName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitShowRelaylogEvent(MySQLStatementParser.ShowRelaylogEventContext ctx) {
        MySQLShowRelayLogEventsStatement result = new MySQLShowRelayLogEventsStatement();
        if (null != ctx.logName()) {
            result.setLogName(((StringLiteralValue)this.visit((ParseTree)ctx.logName().stringLiterals().string_())).getValue());
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        if (null != ctx.channelName()) {
            result.setChannel(((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitShowFunctionCode(MySQLStatementParser.ShowFunctionCodeContext ctx) {
        MySQLShowFunctionCodeStatement result = new MySQLShowFunctionCodeStatement();
        result.setFunctionName(((FunctionSegment)this.visit((ParseTree)ctx.functionName())).getFunctionName());
        return result;
    }

    @Override
    public ASTNode visitShowGrants(MySQLStatementParser.ShowGrantsContext ctx) {
        return new MySQLShowGrantsStatement();
    }

    @Override
    public ASTNode visitShowMasterStatus(MySQLStatementParser.ShowMasterStatusContext ctx) {
        return new MySQLShowMasterStatusStatement();
    }

    @Override
    public ASTNode visitShowSlaveHosts(MySQLStatementParser.ShowSlaveHostsContext ctx) {
        return new MySQLShowSlaveHostsStatement();
    }

    @Override
    public ASTNode visitShowReplicaStatus(MySQLStatementParser.ShowReplicaStatusContext ctx) {
        MySQLShowReplicaStatusStatement result = new MySQLShowReplicaStatusStatement();
        if (null != ctx.channelName()) {
            result.setChannel(((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitShowSlaveStatus(MySQLStatementParser.ShowSlaveStatusContext ctx) {
        MySQLShowSlaveStatusStatement result = new MySQLShowSlaveStatusStatement();
        if (null != ctx.channelName()) {
            result.setChannel(((IdentifierValue)this.visit((ParseTree)ctx.channelName())).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitCreateResourceGroup(MySQLStatementParser.CreateResourceGroupContext ctx) {
        MySQLCreateResourceGroupStatement result = new MySQLCreateResourceGroupStatement();
        result.setGroupName(((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitBinlog(MySQLStatementParser.BinlogContext ctx) {
        return new MySQLBinlogStatement(((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue());
    }

    @Override
    public ASTNode visitFromTable(MySQLStatementParser.FromTableContext ctx) {
        FromTableSegment result = new FromTableSegment();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitShowVariables(MySQLStatementParser.ShowVariablesContext ctx) {
        MySQLShowVariablesStatement result = new MySQLShowVariablesStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCharacterSet(MySQLStatementParser.ShowCharacterSetContext ctx) {
        MySQLShowCharacterSetStatement result = new MySQLShowCharacterSetStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowCollation(MySQLStatementParser.ShowCollationContext ctx) {
        MySQLShowCollationStatement result = new MySQLShowCollationStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowFunctionStatus(MySQLStatementParser.ShowFunctionStatusContext ctx) {
        MySQLShowFunctionStatusStatement result = new MySQLShowFunctionStatusStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowProcedureStatus(MySQLStatementParser.ShowProcedureStatusContext ctx) {
        MySQLShowProcedureStatusStatement result = new MySQLShowProcedureStatusStatement();
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowOpenTables(MySQLStatementParser.ShowOpenTablesContext ctx) {
        MySQLShowOpenTablesStatement result = new MySQLShowOpenTablesStatement();
        if (null != ctx.fromSchema()) {
            result.setFromSchema((FromSchemaSegment)this.visit((ParseTree)ctx.fromSchema()));
        }
        if (null != ctx.showFilter()) {
            result.setFilter((ShowFilterSegment)this.visit((ParseTree)ctx.showFilter()));
        }
        result.addParameterMarkerSegments(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitShowPlugins(MySQLStatementParser.ShowPluginsContext ctx) {
        return new MySQLShowPluginsStatement();
    }

    @Override
    public ASTNode visitShowPrivileges(MySQLStatementParser.ShowPrivilegesContext ctx) {
        return new MySQLShowPrivilegesStatement();
    }

    @Override
    public ASTNode visitShutdown(MySQLStatementParser.ShutdownContext ctx) {
        return new MySQLShutdownStatement();
    }

    @Override
    public ASTNode visitShowProcesslist(MySQLStatementParser.ShowProcesslistContext ctx) {
        return new MySQLShowProcessListStatement();
    }

    @Override
    public ASTNode visitShowCreateUser(MySQLStatementParser.ShowCreateUserContext ctx) {
        MySQLShowCreateUserStatement result = new MySQLShowCreateUserStatement();
        result.setName(((IdentifierValue)this.visit((ParseTree)ctx.username())).getValue());
        return result;
    }

    @Override
    public ASTNode visitSetVariable(MySQLStatementParser.SetVariableContext ctx) {
        MySQLSetStatement result = new MySQLSetStatement();
        Collection<VariableAssignSegment> variableAssigns = this.getVariableAssigns(ctx.optionValueList());
        result.getVariableAssigns().addAll(variableAssigns);
        return result;
    }

    private Collection<VariableAssignSegment> getVariableAssigns(MySQLStatementParser.OptionValueListContext ctx) {
        LinkedList<VariableAssignSegment> result = new LinkedList<VariableAssignSegment>();
        if (null == ctx.optionValueNoOptionType()) {
            VariableAssignSegment variableAssign = new VariableAssignSegment();
            variableAssign.setStartIndex(ctx.start.getStartIndex());
            variableAssign.setStopIndex(ctx.setExprOrDefault().stop.getStopIndex());
            VariableSegment variable = new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText());
            variable.setScope(ctx.optionType().getText());
            variableAssign.setVariable(variable);
            variableAssign.setAssignValue(ctx.setExprOrDefault().getText());
            result.add(variableAssign);
        } else {
            result.add(this.getVariableAssign(ctx.optionValueNoOptionType()));
        }
        for (MySQLStatementParser.OptionValueContext each : ctx.optionValue()) {
            result.add(this.getVariableAssign(each));
        }
        return result;
    }

    private VariableAssignSegment getVariableAssign(MySQLStatementParser.OptionValueNoOptionTypeContext ctx) {
        VariableAssignSegment result = new VariableAssignSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.NAMES()) {
            result.setVariable(new VariableSegment(ctx.NAMES().getSymbol().getStartIndex(), ctx.NAMES().getSymbol().getStopIndex(), "character_set_client"));
            result.setAssignValue(ctx.charsetName().getText());
        } else if (null != ctx.internalVariableName()) {
            result.setVariable(new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText()));
            result.setAssignValue(ctx.setExprOrDefault().getText());
        } else if (null != ctx.userVariable()) {
            result.setVariable(new VariableSegment(ctx.userVariable().start.getStartIndex(), ctx.userVariable().stop.getStopIndex(), ctx.userVariable().getText()));
            result.setAssignValue(ctx.expr().getText());
        } else if (null != ctx.setSystemVariable()) {
            VariableSegment variable = new VariableSegment(ctx.setSystemVariable().start.getStartIndex(), ctx.setSystemVariable().stop.getStopIndex(), ctx.setSystemVariable().internalVariableName().getText());
            result.setVariable(variable);
            result.setAssignValue(ctx.setExprOrDefault().getText());
            MySQLStatementParser.OptionTypeContext optionType = ctx.setSystemVariable().optionType();
            variable.setScope(null != optionType ? optionType.getText() : "SESSION");
        }
        return result;
    }

    private VariableAssignSegment getVariableAssign(MySQLStatementParser.OptionValueContext ctx) {
        if (null != ctx.optionValueNoOptionType()) {
            return this.getVariableAssign(ctx.optionValueNoOptionType());
        }
        VariableAssignSegment result = new VariableAssignSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        VariableSegment variable = new VariableSegment(ctx.internalVariableName().start.getStartIndex(), ctx.internalVariableName().stop.getStopIndex(), ctx.internalVariableName().getText());
        variable.setScope(ctx.optionType().getText());
        result.setVariable(variable);
        result.setAssignValue(ctx.setExprOrDefault().getText());
        return result;
    }

    @Override
    public ASTNode visitSetCharacter(MySQLStatementParser.SetCharacterContext ctx) {
        VariableAssignSegment characterSet = new VariableAssignSegment();
        int startIndex = null != ctx.CHARSET() ? ctx.CHARSET().getSymbol().getStartIndex() : ctx.CHARACTER().getSymbol().getStartIndex();
        int stopIndex = null != ctx.CHARSET() ? ctx.CHARSET().getSymbol().getStopIndex() : ctx.SET(1).getSymbol().getStopIndex();
        String variableName = null != ctx.CHARSET() ? ctx.CHARSET().getText() : "character_set_client";
        VariableSegment variable = new VariableSegment(startIndex, stopIndex, variableName);
        characterSet.setVariable(variable);
        String assignValue = null != ctx.DEFAULT() ? ctx.DEFAULT().getText() : ctx.charsetName().getText();
        characterSet.setAssignValue(assignValue);
        MySQLSetStatement result = new MySQLSetStatement();
        result.getVariableAssigns().add(characterSet);
        return result;
    }

    @Override
    public ASTNode visitFromSchema(MySQLStatementParser.FromSchemaContext ctx) {
        return new FromSchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowLike(MySQLStatementParser.ShowLikeContext ctx) {
        StringLiteralValue literalValue = (StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals());
        return new ShowLikeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), literalValue.getValue());
    }

    @Override
    public ASTNode visitCreateLoadableFunction(MySQLStatementParser.CreateLoadableFunctionContext ctx) {
        return new MySQLCreateLoadableFunctionStatement();
    }

    @Override
    public ASTNode visitInstallComponent(MySQLStatementParser.InstallComponentContext ctx) {
        MySQLInstallComponentStatement result = new MySQLInstallComponentStatement();
        LinkedList<String> components = new LinkedList<String>();
        for (MySQLStatementParser.ComponentNameContext each : ctx.componentName()) {
            components.add(((StringLiteralValue)this.visit((ParseTree)each.string_())).getValue());
        }
        result.getComponents().addAll(components);
        return result;
    }

    @Override
    public ASTNode visitUninstallComponent(MySQLStatementParser.UninstallComponentContext ctx) {
        MySQLUninstallComponentStatement result = new MySQLUninstallComponentStatement();
        LinkedList<String> components = new LinkedList<String>();
        for (MySQLStatementParser.ComponentNameContext each : ctx.componentName()) {
            components.add(((StringLiteralValue)this.visit((ParseTree)each.string_())).getValue());
        }
        result.getComponents().addAll(components);
        return result;
    }

    @Override
    public ASTNode visitRestart(MySQLStatementParser.RestartContext ctx) {
        return new MySQLRestartStatement();
    }

    @Override
    public ASTNode visitSetResourceGroup(MySQLStatementParser.SetResourceGroupContext ctx) {
        MySQLSetResourceGroupStatement result = new MySQLSetResourceGroupStatement();
        result.setGroupName(((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCheckTable(MySQLStatementParser.CheckTableContext ctx) {
        MySQLCheckTableStatement result = new MySQLCheckTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitDropResourceGroup(MySQLStatementParser.DropResourceGroupContext ctx) {
        MySQLDropResourceGroupStatement result = new MySQLDropResourceGroupStatement();
        result.setGroupName(((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitAlterResourceGroup(MySQLStatementParser.AlterResourceGroupContext ctx) {
        MySQLAlterResourceGroupStatement result = new MySQLAlterResourceGroupStatement();
        result.setGroupName(((IdentifierValue)this.visit((ParseTree)ctx.groupName())).getValue());
        return result;
    }

    @Override
    public ASTNode visitDelimiter(MySQLStatementParser.DelimiterContext ctx) {
        MySQLDelimiterStatement result = new MySQLDelimiterStatement();
        result.setDelimiterName(ctx.delimiterName().getText());
        return result;
    }

    @Override
    public ASTNode visitHelp(MySQLStatementParser.HelpContext ctx) {
        MySQLHelpStatement result = new MySQLHelpStatement();
        result.setSearchString(ctx.textOrIdentifier().getText());
        return result;
    }
}

