/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class SQLStatementParserEngineFactory {
    private static final Map<String, SQLStatementParserEngine> ENGINES = new ConcurrentHashMap<String, SQLStatementParserEngine>();

    public static SQLStatementParserEngine getSQLStatementParserEngine(String databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption, boolean isParseComment) {
        SQLStatementParserEngine result = ENGINES.get(databaseType);
        if (null == result) {
            result = ENGINES.computeIfAbsent(databaseType, key -> new SQLStatementParserEngine((String)key, sqlStatementCacheOption, parseTreeCacheOption, isParseComment));
        }
        return result;
    }

    @Generated
    private SQLStatementParserEngineFactory() {
    }
}

