/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheBuilder;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserExecutor;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLStatementParserEngine {
    private final SQLStatementParserExecutor sqlStatementParserExecutor;
    private final LoadingCache<String, SQLStatement> sqlStatementCache;

    public SQLStatementParserEngine(String databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption, boolean isParseComment) {
        this.sqlStatementParserExecutor = new SQLStatementParserExecutor(databaseType, parseTreeCacheOption, isParseComment);
        this.sqlStatementCache = SQLStatementCacheBuilder.build(databaseType, sqlStatementCacheOption, parseTreeCacheOption, isParseComment);
    }

    public SQLStatement parse(String sql, boolean useCache) {
        return useCache ? (SQLStatement)this.sqlStatementCache.get((Object)sql) : this.sqlStatementParserExecutor.parse(sql);
    }
}

