/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser;

import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.shardingsphere.distsql.parser.api.DistSQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngineFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingSphereSQLParserEngine {
    private final SQLStatementParserEngine sqlStatementParserEngine;
    private final DistSQLStatementParserEngine distSQLStatementParserEngine;

    public ShardingSphereSQLParserEngine(String databaseTypeName) {
        this.sqlStatementParserEngine = SQLStatementParserEngineFactory.getSQLStatementParserEngine(databaseTypeName);
        this.distSQLStatementParserEngine = new DistSQLStatementParserEngine();
    }

    public SQLStatement parse(String sql, boolean useCache) {
        return this.parse0(sql, useCache);
    }

    private SQLStatement parse0(String sql, boolean useCache) {
        try {
            return this.sqlStatementParserEngine.parse(sql, useCache);
        }
        catch (ParseCancellationException | SQLParsingException originalEx) {
            try {
                return this.distSQLStatementParserEngine.parse(sql);
            }
            catch (SQLParsingException ignored) {
                throw originalEx;
            }
        }
    }
}

