/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl;

import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnProjectionConverter
implements SQLSegmentConverter<ColumnProjectionSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(ColumnProjectionSegment segment) {
        if (segment.getAlias().isPresent()) {
            Optional<SqlIdentifier> columnSqlIdentifier = new ColumnConverter().convertToSQLNode(segment.getColumn());
            SqlIdentifier aliasSqlIdentifier = new SqlIdentifier((String)segment.getAlias().get(), SqlParserPos.ZERO);
            return Optional.of(new SqlBasicCall((SqlOperator)new SqlAsOperator(), new SqlNode[]{(SqlNode)columnSqlIdentifier.get(), aliasSqlIdentifier}, SqlParserPos.ZERO));
        }
        return new ColumnConverter().convertToSQLNode(segment.getColumn()).map(optional -> optional);
    }

    @Override
    public Optional<ColumnProjectionSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlBasicCall) {
            List operands = ((SqlBasicCall)sqlNode).getOperandList();
            Optional<ColumnSegment> columnSegment = new ColumnConverter().convertToSQLSegment((SqlIdentifier)operands.get(0));
            if (!columnSegment.isPresent()) {
                return Optional.empty();
            }
            ColumnProjectionSegment columnProjectionSegment = new ColumnProjectionSegment(columnSegment.get());
            if (2 == operands.size()) {
                SqlIdentifier aliasSqlNode = (SqlIdentifier)operands.get(1);
                columnProjectionSegment.setAlias(new AliasSegment(this.getStartIndex((SqlNode)aliasSqlNode), this.getStopIndex((SqlNode)aliasSqlNode), new IdentifierValue((String)aliasSqlNode.names.get(0))));
            }
            return Optional.of(columnProjectionSegment);
        }
        if (sqlNode instanceof SqlIdentifier) {
            return new ColumnConverter().convertToSQLSegment((SqlIdentifier)sqlNode).map(ColumnProjectionSegment::new);
        }
        return Optional.empty();
    }
}

