/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.AggregationProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.ColumnProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.ExpressionProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.ShorthandProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.SubqueryProjectionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;

public final class ProjectionsConverter
implements SQLSegmentConverter<ProjectionsSegment, SqlNodeList> {
    @Override
    public Optional<SqlNodeList> convertToSQLNode(ProjectionsSegment segment) {
        ArrayList projectionSQLNodes = new ArrayList(segment.getProjections().size());
        for (ProjectionSegment each : segment.getProjections()) {
            this.getProjectionSQLNode(each).ifPresent(projectionSQLNodes::add);
        }
        return Optional.of(new SqlNodeList(projectionSQLNodes, SqlParserPos.ZERO));
    }

    private Optional<SqlNode> getProjectionSQLNode(ProjectionSegment segment) {
        if (segment instanceof ColumnProjectionSegment) {
            return new ColumnProjectionConverter().convertToSQLNode((ColumnProjectionSegment)segment);
        }
        if (segment instanceof ExpressionProjectionSegment) {
            return new ExpressionProjectionConverter().convertToSQLNode((ExpressionProjectionSegment)segment);
        }
        if (segment instanceof ShorthandProjectionSegment) {
            return new ShorthandProjectionConverter().convertToSQLNode((ShorthandProjectionSegment)segment).map(optional -> optional);
        }
        if (segment instanceof SubqueryProjectionSegment) {
            return new SubqueryProjectionConverter().convertToSQLNode((SubqueryProjectionSegment)segment);
        }
        if (segment instanceof AggregationProjectionSegment) {
            return new AggregationProjectionConverter().convertToSQLNode((AggregationProjectionSegment)segment).map(optional -> optional);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ProjectionsSegment> convertToSQLSegment(SqlNodeList sqlNodeList) {
        ArrayList projections = new ArrayList();
        for (SqlNode each : sqlNodeList) {
            this.getProjectionSegment(each).ifPresent(projections::add);
        }
        int startIndex = ((ProjectionSegment)projections.get(0)).getStartIndex();
        int stopIndex = this.getProjectionsSegmentStopIndex(sqlNodeList.get(sqlNodeList.size() - 1), (ProjectionSegment)projections.get(projections.size() - 1));
        ProjectionsSegment result = new ProjectionsSegment(startIndex, stopIndex);
        result.getProjections().addAll(projections);
        return Optional.of(result);
    }

    private int getProjectionsSegmentStopIndex(SqlNode lastSqlNode, ProjectionSegment projectionSegment) {
        int stopIndex = projectionSegment.getStopIndex();
        if (lastSqlNode instanceof SqlBasicCall && SqlKind.AS == ((SqlBasicCall)lastSqlNode).getOperator().getKind()) {
            stopIndex = this.getStopIndex((SqlNode)((SqlBasicCall)lastSqlNode).getOperandList().get(1));
        }
        return stopIndex;
    }

    private Optional<ProjectionSegment> getProjectionSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
            if (SqlIdentifier.STAR.names.equals((Object)sqlIdentifier.names) || this.isOwnerShorthandProjection(sqlIdentifier)) {
                return new ShorthandProjectionConverter().convertToSQLSegment(sqlIdentifier).map(optional -> optional);
            }
            return new ColumnProjectionConverter().convertToSQLSegment((SqlNode)sqlIdentifier).map(optional -> optional);
        }
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            if (AggregationType.isAggregationType((String)sqlBasicCall.getOperator().getName()) || AggregationProjectionConverter.isAsOperatorAggregationType(sqlBasicCall)) {
                return new AggregationProjectionConverter().convertToSQLSegment(sqlBasicCall).map(optional -> optional);
            }
            if (null != sqlBasicCall.getOperator() && SqlKind.AS == sqlBasicCall.getOperator().getKind() && !(sqlBasicCall.getOperandList().get(0) instanceof SqlNumericLiteral)) {
                return new ColumnProjectionConverter().convertToSQLSegment(sqlNode).map(optional -> optional);
            }
            return new ExpressionProjectionConverter().convertToSQLSegment(sqlNode).map(optional -> optional);
        }
        if (sqlNode instanceof SqlSelect || sqlNode instanceof SqlOrderBy) {
            return new SubqueryProjectionConverter().convertToSQLSegment(sqlNode).map(optional -> optional);
        }
        return Optional.empty();
    }

    private boolean isOwnerShorthandProjection(SqlIdentifier sqlIdentifier) {
        return 2 == sqlIdentifier.names.size() && SqlIdentifier.STAR.names.equals((Object)ImmutableList.of((Object)sqlIdentifier.names.get(1)));
    }
}

