/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.original;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.original.FilterableSchema;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanExecutor;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class OriginalFilterableExecutor
implements FederationExecutor {
    public static final String CONNECTION_URL = "jdbc:calcite:";
    public static final String DRIVER_NAME = "org.apache.calcite.jdbc.Driver";
    private final String schemaName;
    private final OptimizerContext optimizerContext;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private Statement statement;

    @Override
    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        LogicSQL logicSQL = federationContext.getLogicSQL();
        Connection connection = this.createConnection(prepareEngine, callback, federationContext);
        PreparedStatement preparedStatement = connection.prepareStatement(SQLUtil.trimSemicolon((String)logicSQL.getSql()));
        this.setParameters(preparedStatement, logicSQL.getParameters());
        this.statement = preparedStatement;
        return preparedStatement.executeQuery();
    }

    private Connection createConnection(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        Connection result = DriverManager.getConnection(CONNECTION_URL, ((OptimizerParserContext)this.optimizerContext.getParserContexts().get(this.schemaName)).getDialectProps());
        this.addSchema(result.unwrap(CalciteConnection.class), prepareEngine, callback, federationContext);
        return result;
    }

    private void addSchema(CalciteConnection connection, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        FilterableTableScanExecutorContext executorContext = new FilterableTableScanExecutorContext(this.schemaName, this.props, federationContext);
        FilterableTableScanExecutor executor = new FilterableTableScanExecutor(prepareEngine, this.jdbcExecutor, callback, this.optimizerContext, executorContext);
        FilterableSchema schema = new FilterableSchema((FederationSchemaMetaData)this.optimizerContext.getFederationMetaData().getSchemas().get(this.schemaName), executor);
        connection.getRootSchema().add(this.schemaName, (Schema)schema);
        connection.setSchema(this.schemaName);
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        int count = 1;
        for (Object each : parameters) {
            preparedStatement.setObject(count, each);
            ++count;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.statement && !this.statement.isClosed()) {
            Connection connection = this.statement.getConnection();
            this.statement.close();
            connection.close();
        }
    }

    @Generated
    public OriginalFilterableExecutor(String schemaName, OptimizerContext optimizerContext, ConfigurationProperties props, JDBCExecutor jdbcExecutor) {
        this.schemaName = schemaName;
        this.optimizerContext = optimizerContext;
        this.props = props;
        this.jdbcExecutor = jdbcExecutor;
    }

    static {
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

