/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ShowProcessListSimpleLock {
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 5000L;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean awaitDefaultTime() {
        return this.condition.await(5000L, TimeUnit.MILLISECONDS);
    }

    public void doNotify() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

