/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.hook.SPISQLExecutionHook;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class JDBCExecutorCallback<T>
implements ExecutorCallback<JDBCExecutionUnit, T> {
    private static final Map<String, DataSourceMetaData> CACHED_DATASOURCE_METADATA = new ConcurrentHashMap<String, DataSourceMetaData>();
    private final DatabaseType protocolType;
    private final DatabaseType databaseType;
    private final SQLStatement sqlStatement;
    private final boolean isExceptionThrown;
    private final EventBusContext eventBusContext;

    public JDBCExecutorCallback(DatabaseType databaseType, SQLStatement sqlStatement, boolean isExceptionThrown, EventBusContext eventBusContext) {
        this(databaseType, databaseType, sqlStatement, isExceptionThrown, eventBusContext);
    }

    @Override
    public final Collection<T> execute(Collection<JDBCExecutionUnit> executionUnits, boolean isTrunkThread, Map<String, Object> dataMap) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (JDBCExecutionUnit each : executionUnits) {
            T executeResult = this.execute(each, isTrunkThread, dataMap);
            if (null == executeResult) continue;
            result.add(executeResult);
        }
        return result;
    }

    private T execute(JDBCExecutionUnit jdbcExecutionUnit, boolean isTrunkThread, Map<String, Object> dataMap) throws SQLException {
        SQLExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        DataSourceMetaData dataSourceMetaData = this.getDataSourceMetaData(jdbcExecutionUnit.getStorageResource().getConnection().getMetaData());
        SPISQLExecutionHook sqlExecutionHook = new SPISQLExecutionHook();
        try {
            SQLUnit sqlUnit = jdbcExecutionUnit.getExecutionUnit().getSqlUnit();
            sqlExecutionHook.start(jdbcExecutionUnit.getExecutionUnit().getDataSourceName(), sqlUnit.getSql(), sqlUnit.getParameters(), dataSourceMetaData, isTrunkThread, dataMap);
            T result = this.executeSQL(sqlUnit.getSql(), jdbcExecutionUnit.getStorageResource(), jdbcExecutionUnit.getConnectionMode());
            sqlExecutionHook.finishSuccess();
            this.finishReport(dataMap, jdbcExecutionUnit);
            return result;
        }
        catch (SQLException ex) {
            Optional<T> saneResult;
            if (!this.databaseType.equals(this.protocolType) && (saneResult = this.getSaneResult(this.sqlStatement, ex)).isPresent()) {
                return isTrunkThread ? (T)saneResult.get() : null;
            }
            sqlExecutionHook.finishFailure(ex);
            SQLExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }

    private DataSourceMetaData getDataSourceMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        String url = databaseMetaData.getURL();
        if (CACHED_DATASOURCE_METADATA.containsKey(url)) {
            return CACHED_DATASOURCE_METADATA.get(url);
        }
        DataSourceMetaData result = this.databaseType.getDataSourceMetaData(url, databaseMetaData.getUserName());
        CACHED_DATASOURCE_METADATA.put(url, result);
        return result;
    }

    private void finishReport(Map<String, Object> dataMap, SQLExecutionUnit executionUnit) {
        if (dataMap.containsKey(ExecuteProcessConstants.EXECUTE_ID.name())) {
            ExecuteProcessEngine.finishExecution(dataMap.get(ExecuteProcessConstants.EXECUTE_ID.name()).toString(), executionUnit, this.eventBusContext);
        }
    }

    protected abstract T executeSQL(String var1, Statement var2, ConnectionMode var3) throws SQLException;

    protected abstract Optional<T> getSaneResult(SQLStatement var1, SQLException var2);

    @Generated
    public JDBCExecutorCallback(DatabaseType protocolType, DatabaseType databaseType, SQLStatement sqlStatement, boolean isExceptionThrown, EventBusContext eventBusContext) {
        this.protocolType = protocolType;
        this.databaseType = databaseType;
        this.sqlStatement = sqlStatement;
        this.isExceptionThrown = isExceptionThrown;
        this.eventBusContext = eventBusContext;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

