/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.builder.JDBCExecutionUnitBuilder;

public final class PreparedStatementExecutionUnitBuilder
implements JDBCExecutionUnitBuilder {
    @Override
    public JDBCExecutionUnit build(ExecutionUnit executionUnit, ExecutorJDBCManager executorManager, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(executionUnit.getSqlUnit().getSql(), executionUnit.getSqlUnit().getParameters(), executorManager, connection, connectionMode, option);
        return new JDBCExecutionUnit(executionUnit, connectionMode, preparedStatement);
    }

    private PreparedStatement createPreparedStatement(String sql, List<Object> parameters, ExecutorJDBCManager executorJDBCManager, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        return (PreparedStatement)executorJDBCManager.createStorageResource(sql, parameters, connection, connectionMode, option);
    }

    public String getType() {
        return "JDBC.PREPARED_STATEMENT";
    }
}

