/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.builder.global;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.global.DefaultGlobalRuleConfigurationBuilder;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRuleBuilder;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPIRegistry;

public final class GlobalRulesBuilder {
    public static Collection<ShardingSphereRule> buildRules(Collection<RuleConfiguration> globalRuleConfigs, Map<String, ShardingSphereDatabase> databases, ConfigurationProperties props) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (Map.Entry<RuleConfiguration, GlobalRuleBuilder> entry : GlobalRulesBuilder.getRuleBuilderMap(globalRuleConfigs).entrySet()) {
            result.add(entry.getValue().build(entry.getKey(), databases, props));
        }
        return result;
    }

    private static Map<RuleConfiguration, GlobalRuleBuilder> getRuleBuilderMap(Collection<RuleConfiguration> globalRuleConfigs) {
        LinkedHashMap<RuleConfiguration, GlobalRuleBuilder> result = new LinkedHashMap<RuleConfiguration, GlobalRuleBuilder>();
        result.putAll(OrderedSPIRegistry.getRegisteredServices(GlobalRuleBuilder.class, globalRuleConfigs));
        result.putAll(GlobalRulesBuilder.getMissedDefaultRuleBuilderMap(result));
        return result;
    }

    private static Map<RuleConfiguration, GlobalRuleBuilder> getMissedDefaultRuleBuilderMap(Map<RuleConfiguration, GlobalRuleBuilder> builders) {
        LinkedHashMap<RuleConfiguration, GlobalRuleBuilder> result = new LinkedHashMap<RuleConfiguration, GlobalRuleBuilder>();
        Map defaultBuilders = OrderedSPIRegistry.getRegisteredServices(DefaultGlobalRuleConfigurationBuilder.class, GlobalRulesBuilder.getMissedDefaultRuleBuilders(builders.values()));
        for (Map.Entry entry : defaultBuilders.entrySet()) {
            result.put((RuleConfiguration)((DefaultGlobalRuleConfigurationBuilder)entry.getValue()).build(), (GlobalRuleBuilder)entry.getKey());
        }
        return result;
    }

    private static Collection<GlobalRuleBuilder> getMissedDefaultRuleBuilders(Collection<GlobalRuleBuilder> configuredBuilders) {
        Collection configuredBuilderClasses = configuredBuilders.stream().map(each -> each.getClass()).collect(Collectors.toSet());
        return OrderedSPIRegistry.getRegisteredServices(GlobalRuleBuilder.class).stream().filter(each -> !configuredBuilderClasses.contains(each.getClass())).collect(Collectors.toList());
    }

    @Generated
    private GlobalRulesBuilder() {
    }
}

