/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.user.yaml.swapper;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.metadata.user.yaml.config.YamlUserConfiguration;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;

public final class YamlUserSwapper
implements YamlConfigurationSwapper<YamlUserConfiguration, ShardingSphereUser> {
    public YamlUserConfiguration swapToYamlConfiguration(ShardingSphereUser data) {
        if (Objects.isNull(data)) {
            return null;
        }
        YamlUserConfiguration result = new YamlUserConfiguration();
        result.setUser(data.getGrantee().toString());
        result.setPassword(data.getPassword());
        result.setAuth(data.getAuth());
        return result;
    }

    public ShardingSphereUser swapToObject(YamlUserConfiguration yamlConfig) {
        if (Objects.isNull(yamlConfig)) {
            return null;
        }
        Grantee grantee = this.convertYamlUserToGrantee(yamlConfig.getUser());
        return new ShardingSphereUser(grantee.getUsername(), yamlConfig.getPassword(), grantee.getHostname(), yamlConfig.getAuth());
    }

    private Grantee convertYamlUserToGrantee(String yamlUser) {
        if (!yamlUser.contains("@")) {
            return new Grantee(yamlUser, "");
        }
        String username = yamlUser.substring(0, yamlUser.indexOf("@"));
        String hostname = yamlUser.substring(yamlUser.indexOf("@") + 1);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0, (String)"user configuration `%s` is invalid, the legal format is `username@hostname`", (Object)yamlUser);
        return new Grantee(username, hostname);
    }
}

