/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.data.collector;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class ShardingSphereTableDataCollectorUtil {
    public static Collection<ShardingSphereRowData> collectRowData(Collection<DataSource> dataSources, String sql, ShardingSphereTable table, Collection<String> selectedColumnNames) throws SQLException {
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        for (DataSource each : dataSources) {
            Connection connection = each.getConnection();
            Throwable throwable = null;
            try {
                Statement statement = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    ResultSet resultSet = statement.executeQuery(sql);
                    Throwable throwable3 = null;
                    try {
                        result.addAll(ShardingSphereTableDataCollectorUtil.getRows(resultSet, table, selectedColumnNames));
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable3 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable2 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                connection.close();
            }
        }
        return result;
    }

    private static Collection<ShardingSphereRowData> getRows(ResultSet resultSet, ShardingSphereTable table, Collection<String> selectedColumnNames) throws SQLException {
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        while (resultSet.next()) {
            result.add(new ShardingSphereRowData(ShardingSphereTableDataCollectorUtil.getRow(table, resultSet, selectedColumnNames)));
        }
        return result;
    }

    private static List<Object> getRow(ShardingSphereTable table, ResultSet resultSet, Collection<String> selectedColumnNames) throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (ShardingSphereColumn each : table.getColumns().values()) {
            if (selectedColumnNames.contains(each.getName())) {
                result.add(ShardingSphereTableDataCollectorUtil.convertIfNecessary(resultSet.getObject(each.getName()), each.getDataType()));
                continue;
            }
            result.add(ShardingSphereTableDataCollectorUtil.mockValue(each.getDataType()));
        }
        return result;
    }

    private static Object mockValue(int dataType) {
        switch (dataType) {
            case -5: {
                return 0L;
            }
            case 1: 
            case 12: 
            case 1111: 
            case 2003: {
                return "";
            }
            case 4: 
            case 5: {
                return 0;
            }
            case 7: {
                return Float.valueOf("0");
            }
            case -7: {
                return false;
            }
        }
        return null;
    }

    private static Object convertIfNecessary(Object data, int dataType) {
        if (2003 == dataType) {
            return null == data ? null : data.toString();
        }
        if (-5 == dataType) {
            return null == data ? null : Long.valueOf(data.toString());
        }
        return data;
    }
}

