/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.state;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.datasource.state.DataSourceState;
import org.apache.shardingsphere.infra.datasource.state.exception.UnavailableDataSourceException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceStateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceStateManager.class);
    private static final DataSourceStateManager INSTANCE = new DataSourceStateManager();
    private final Map<String, DataSourceState> dataSourceStates = new ConcurrentHashMap<String, DataSourceState>();
    private volatile boolean forceStart;
    private volatile boolean initialized;

    public static DataSourceStateManager getInstance() {
        return INSTANCE;
    }

    public void initStates(String databaseName, Map<String, DataSource> dataSources, Map<String, DataSourceState> storageDataSourceStates, boolean forceStart) {
        this.forceStart = forceStart;
        dataSources.forEach((key, value) -> this.initState(databaseName, storageDataSourceStates, (String)key, (DataSource)value));
        this.initialized = true;
    }

    private void initState(String databaseName, Map<String, DataSourceState> storageDataSourceStates, String actualDataSourceName, DataSource dataSource) {
        DataSourceState storageState = storageDataSourceStates.get(this.getCacheKey(databaseName, actualDataSourceName));
        if (DataSourceState.DISABLED == storageState) {
            this.dataSourceStates.put(this.getCacheKey(databaseName, actualDataSourceName), storageState);
        } else {
            this.checkState(databaseName, actualDataSourceName, dataSource);
        }
    }

    private void checkState(String databaseName, String actualDataSourceName, DataSource dataSource) {
        try (Connection ignored = dataSource.getConnection();){
            this.dataSourceStates.put(this.getCacheKey(databaseName, actualDataSourceName), DataSourceState.ENABLED);
        }
        catch (SQLException ex) {
            ShardingSpherePreconditions.checkState((boolean)this.forceStart, () -> new UnavailableDataSourceException(ex));
            log.error("Data source unavailable, ignored with the -f parameter.", (Throwable)ex);
        }
    }

    public Collection<DataSource> getEnabledDataSources(String databaseName, DatabaseConfiguration databaseConfig) {
        return databaseConfig.getDataSources().isEmpty() ? Collections.emptyList() : this.getEnabledDataSourceMap(databaseName, databaseConfig.getDataSources()).values();
    }

    public Map<String, DataSource> getEnabledDataSourceMap(String databaseName, Map<String, DataSource> dataSources) {
        if (dataSources.isEmpty() || !this.initialized) {
            return dataSources;
        }
        Map<String, DataSource> result = this.filterDisabledDataSources(databaseName, dataSources);
        this.checkForceConnection(result);
        return result;
    }

    private Map<String, DataSource> filterDisabledDataSources(String databaseName, Map<String, DataSource> dataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSources.size(), 1.0f);
        dataSources.forEach((key, value) -> {
            DataSourceState dataSourceState = this.dataSourceStates.get(this.getCacheKey(databaseName, (String)key));
            if (DataSourceState.DISABLED != dataSourceState) {
                result.put((String)key, (DataSource)value);
            }
        });
        return result;
    }

    private void checkForceConnection(Map<String, DataSource> dataSources) {
        if (this.forceStart) {
            dataSources.entrySet().removeIf(entry -> {
                try (Connection ignored = ((DataSource)entry.getValue()).getConnection();){
                    boolean bl = false;
                    return bl;
                }
                catch (SQLException ex) {
                    log.error("Data source state unavailable, ignored with the -f parameter.", (Throwable)ex);
                    return true;
                }
            });
        }
    }

    public void updateState(String databaseName, String actualDataSourceName, DataSourceState dataSourceState) {
        this.dataSourceStates.put(this.getCacheKey(databaseName, actualDataSourceName), dataSourceState);
    }

    private String getCacheKey(String databaseName, String dataSourceName) {
        return databaseName + "." + dataSourceName;
    }

    @Generated
    private DataSourceStateManager() {
    }
}

