/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.metadata.type.hikari;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class HikariDataSourcePoolPropertiesValidator
implements DataSourcePoolPropertiesValidator {
    private static final long CONNECTION_TIMEOUT_FLOOR = 250L;
    private static final long MAX_LIFETIME_FLOOR = TimeUnit.SECONDS.toMillis(30L);
    private static final long KEEP_ALIVE_TIME_FLOOR = TimeUnit.SECONDS.toMillis(30L);

    @Override
    public void validateProperties(DataSourceProperties dataSourceProps) throws IllegalArgumentException {
        this.validateConnectionTimeout(dataSourceProps);
        this.validateIdleTimeout(dataSourceProps);
        this.validateMaxLifetime(dataSourceProps);
        this.validateMaximumPoolSize(dataSourceProps);
        this.validateMinimumIdle(dataSourceProps);
        this.validateKeepaliveTime(dataSourceProps);
    }

    private void validateConnectionTimeout(DataSourceProperties dataSourceProps) {
        if (!this.checkValueExist(dataSourceProps, "connectionTimeout")) {
            return;
        }
        long connectionTimeout = Long.parseLong(dataSourceProps.getAllLocalProperties().get("connectionTimeout").toString());
        ShardingSpherePreconditions.checkState((connectionTimeout >= 250L ? 1 : 0) != 0, () -> new IllegalArgumentException(String.format("connectionTimeout cannot be less than %sms", 250L)));
    }

    private void validateIdleTimeout(DataSourceProperties dataSourceProps) {
        if (!this.checkValueExist(dataSourceProps, "idleTimeout")) {
            return;
        }
        long idleTimeout = Long.parseLong(dataSourceProps.getAllLocalProperties().get("idleTimeout").toString());
        ShardingSpherePreconditions.checkState((idleTimeout >= 0L ? 1 : 0) != 0, () -> new IllegalArgumentException("idleTimeout cannot be negative"));
    }

    private void validateMaxLifetime(DataSourceProperties dataSourceProps) {
        if (!this.checkValueExist(dataSourceProps, "maxLifetime")) {
            return;
        }
        long maxLifetime = Long.parseLong(dataSourceProps.getAllLocalProperties().get("maxLifetime").toString());
        ShardingSpherePreconditions.checkState((maxLifetime >= MAX_LIFETIME_FLOOR ? 1 : 0) != 0, () -> new IllegalArgumentException(String.format("maxLifetime cannot be less than %sms", MAX_LIFETIME_FLOOR)));
    }

    private void validateMaximumPoolSize(DataSourceProperties dataSourceProps) {
        if (!this.checkValueExist(dataSourceProps, "maximumPoolSize")) {
            return;
        }
        int maximumPoolSize = Integer.parseInt(dataSourceProps.getAllLocalProperties().get("maximumPoolSize").toString());
        ShardingSpherePreconditions.checkState((maximumPoolSize >= 1 ? 1 : 0) != 0, () -> new IllegalArgumentException("maxPoolSize cannot be less than 1"));
    }

    private void validateMinimumIdle(DataSourceProperties dataSourceProps) {
        if (!this.checkValueExist(dataSourceProps, "minimumIdle")) {
            return;
        }
        int minimumIdle = Integer.parseInt(dataSourceProps.getAllLocalProperties().get("minimumIdle").toString());
        ShardingSpherePreconditions.checkState((minimumIdle >= 0 ? 1 : 0) != 0, () -> new IllegalArgumentException("minimumIdle cannot be negative"));
    }

    private void validateKeepaliveTime(DataSourceProperties dataSourceProps) {
        if (!this.checkValueExist(dataSourceProps, "keepaliveTime")) {
            return;
        }
        int keepaliveTime = Integer.parseInt(dataSourceProps.getAllLocalProperties().get("keepaliveTime").toString());
        if (keepaliveTime == 0) {
            return;
        }
        ShardingSpherePreconditions.checkState(((long)keepaliveTime >= KEEP_ALIVE_TIME_FLOOR ? 1 : 0) != 0, () -> new IllegalArgumentException(String.format("keepaliveTime cannot be less than %sms", KEEP_ALIVE_TIME_FLOOR)));
    }

    private boolean checkValueExist(DataSourceProperties dataSourceProps, String key) {
        return dataSourceProps.getAllLocalProperties().containsKey(key) && Objects.nonNull(dataSourceProps.getAllLocalProperties().get(key));
    }
}

