/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.schema.swapper;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereSchema;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereView;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlViewSwapper;

public final class YamlSchemaSwapper
implements YamlConfigurationSwapper<YamlShardingSphereSchema, ShardingSphereSchema> {
    public YamlShardingSphereSchema swapToYamlConfiguration(ShardingSphereSchema schema) {
        Map tables = schema.getAllTableNames().stream().collect(Collectors.toMap(each -> each, each -> this.swapYamlTable(schema.getTable((String)each)), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        Map views = schema.getAllViewNames().stream().collect(Collectors.toMap(each -> each, each -> this.swapYamlView(schema.getView((String)each)), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        YamlShardingSphereSchema result = new YamlShardingSphereSchema();
        result.setTables(tables);
        result.setViews(views);
        return result;
    }

    public ShardingSphereSchema swapToObject(YamlShardingSphereSchema yamlConfig) {
        return Optional.ofNullable(yamlConfig).map(this::swapSchema).orElseGet(ShardingSphereSchema::new);
    }

    private ShardingSphereSchema swapSchema(YamlShardingSphereSchema schema) {
        LinkedHashMap<String, ShardingSphereTable> tables = null == schema.getTables() || schema.getTables().isEmpty() ? new LinkedHashMap<String, ShardingSphereTable>() : (Map)schema.getTables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapTable((YamlShardingSphereTable)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        LinkedHashMap<String, ShardingSphereView> views = null == schema.getViews() || schema.getViews().isEmpty() ? new LinkedHashMap<String, ShardingSphereView>() : (Map)schema.getViews().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapView((YamlShardingSphereView)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return new ShardingSphereSchema(tables, views);
    }

    private ShardingSphereTable swapTable(YamlShardingSphereTable table) {
        return new YamlTableSwapper().swapToObject(table);
    }

    private YamlShardingSphereTable swapYamlTable(ShardingSphereTable table) {
        return new YamlTableSwapper().swapToYamlConfiguration(table);
    }

    private ShardingSphereView swapView(YamlShardingSphereView view) {
        return new YamlViewSwapper().swapToObject(view);
    }

    private YamlShardingSphereView swapYamlView(ShardingSphereView view) {
        return new YamlViewSwapper().swapToYamlConfiguration(view);
    }
}

