/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.infra.state.StateType;

public final class ComputeNodeInstance {
    private final InstanceMetaData metaData;
    private final StateContext state = new StateContext();
    private Collection<String> labels = new ArrayList<String>();
    private volatile long workerId;

    public ComputeNodeInstance(InstanceMetaData metaData) {
        this.metaData = metaData;
        this.workerId = -1L;
    }

    public void setLabels(Collection<String> labels) {
        if (null == labels) {
            return;
        }
        this.labels = labels;
    }

    public void switchState(Collection<String> status) {
        this.state.switchState(StateType.CIRCUIT_BREAK, null != status && status.contains(StateType.CIRCUIT_BREAK.name()));
    }

    public String getCurrentInstanceId() {
        return this.metaData.getId();
    }

    @Generated
    public InstanceMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public StateContext getState() {
        return this.state;
    }

    @Generated
    public Collection<String> getLabels() {
        return this.labels;
    }

    @Generated
    public long getWorkerId() {
        return this.workerId;
    }

    @Generated
    public void setWorkerId(long workerId) {
        this.workerId = workerId;
    }
}

