/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.metadata.type.hikari;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.type.hikari.HikariDataSourcePoolFieldMetaData;

public final class HikariDataSourcePoolMetaData
implements DataSourcePoolMetaData {
    private static final Map<String, Object> DEFAULT_PROPERTIES = new HashMap<String, Object>(6, 1.0f);
    private static final Map<String, Object> INVALID_PROPERTIES = new HashMap<String, Object>(2, 1.0f);
    private static final Map<String, String> PROPERTY_SYNONYMS = new HashMap<String, String>(6, 1.0f);
    private static final Collection<String> TRANSIENT_FIELD_NAMES = new LinkedList<String>();

    private static void buildDefaultProperties() {
        DEFAULT_PROPERTIES.put("connectionTimeout", 30000L);
        DEFAULT_PROPERTIES.put("idleTimeout", 60000L);
        DEFAULT_PROPERTIES.put("maxLifetime", 0x200B20L);
        DEFAULT_PROPERTIES.put("maximumPoolSize", 50);
        DEFAULT_PROPERTIES.put("minimumIdle", 1);
        DEFAULT_PROPERTIES.put("readOnly", false);
    }

    private static void buildInvalidProperties() {
        INVALID_PROPERTIES.put("minimumIdle", -1);
        INVALID_PROPERTIES.put("maximumPoolSize", -1);
    }

    private static void buildPropertySynonyms() {
        PROPERTY_SYNONYMS.put("url", "jdbcUrl");
        PROPERTY_SYNONYMS.put("connectionTimeoutMilliseconds", "connectionTimeout");
        PROPERTY_SYNONYMS.put("idleTimeoutMilliseconds", "idleTimeout");
        PROPERTY_SYNONYMS.put("maxLifetimeMilliseconds", "maxLifetime");
        PROPERTY_SYNONYMS.put("maxPoolSize", "maximumPoolSize");
        PROPERTY_SYNONYMS.put("minPoolSize", "minimumIdle");
    }

    private static void buildTransientFieldNames() {
        TRANSIENT_FIELD_NAMES.add("running");
        TRANSIENT_FIELD_NAMES.add("poolName");
        TRANSIENT_FIELD_NAMES.add("closed");
    }

    @Override
    public Map<String, Object> getDefaultProperties() {
        return DEFAULT_PROPERTIES;
    }

    @Override
    public Map<String, Object> getInvalidProperties() {
        return INVALID_PROPERTIES;
    }

    @Override
    public Map<String, String> getPropertySynonyms() {
        return PROPERTY_SYNONYMS;
    }

    @Override
    public Collection<String> getTransientFieldNames() {
        return TRANSIENT_FIELD_NAMES;
    }

    @Override
    public HikariDataSourcePoolFieldMetaData getFieldMetaData() {
        return new HikariDataSourcePoolFieldMetaData();
    }

    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }

    static {
        HikariDataSourcePoolMetaData.buildDefaultProperties();
        HikariDataSourcePoolMetaData.buildInvalidProperties();
        HikariDataSourcePoolMetaData.buildPropertySynonyms();
        HikariDataSourcePoolMetaData.buildTransientFieldNames();
    }
}

