/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.projection.impl;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;

public final class ShorthandProjectionSegmentBinder {
    public static ShorthandProjectionSegment bind(ShorthandProjectionSegment segment, TableSegment boundedTableSegment, Map<String, TableSegmentBinderContext> tableBinderContexts) {
        ShorthandProjectionSegment result = new ShorthandProjectionSegment(segment.getStartIndex(), segment.getStopIndex());
        segment.getOwner().ifPresent(arg_0 -> ((ShorthandProjectionSegment)result).setOwner(arg_0));
        segment.getAliasSegment().ifPresent(arg_0 -> ((ShorthandProjectionSegment)result).setAlias(arg_0));
        if (segment.getOwner().isPresent()) {
            ShorthandProjectionSegmentBinder.expandVisibleColumn(ShorthandProjectionSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, ((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()), result);
        } else {
            ShorthandProjectionSegmentBinder.bindNoOwnerProjections(boundedTableSegment, tableBinderContexts, result);
        }
        return result;
    }

    private static Collection<ProjectionSegment> getProjectionSegmentsByTableAliasOrName(Map<String, TableSegmentBinderContext> tableBinderContexts, String tableAliasOrName) {
        ShardingSpherePreconditions.checkState((boolean)tableBinderContexts.containsKey(tableAliasOrName.toLowerCase()), () -> new IllegalStateException(String.format("Can not find table binder context by table alias or name %s.", tableAliasOrName)));
        return tableBinderContexts.get(tableAliasOrName.toLowerCase()).getProjectionSegments();
    }

    private static void expandVisibleColumn(Collection<ProjectionSegment> projectionSegments, ShorthandProjectionSegment segment) {
        for (ProjectionSegment each : projectionSegments) {
            if (!each.isVisible()) continue;
            segment.getActualProjectionSegments().add(each);
        }
    }

    private static void bindNoOwnerProjections(TableSegment boundedTableSegment, Map<String, TableSegmentBinderContext> tableBinderContexts, ShorthandProjectionSegment segment) {
        if (boundedTableSegment instanceof SimpleTableSegment) {
            String tableAliasOrName = boundedTableSegment.getAliasName().orElseGet(() -> ((SimpleTableSegment)boundedTableSegment).getTableName().getIdentifier().getValue());
            ShorthandProjectionSegmentBinder.expandVisibleColumn(ShorthandProjectionSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, tableAliasOrName), segment);
        } else if (boundedTableSegment instanceof JoinTableSegment) {
            ShorthandProjectionSegmentBinder.expandVisibleColumn(((JoinTableSegment)boundedTableSegment).getDerivedJoinTableProjectionSegments(), segment);
        } else if (boundedTableSegment instanceof SubqueryTableSegment) {
            ShorthandProjectionSegmentBinder.expandVisibleColumn(ShorthandProjectionSegmentBinder.getProjectionSegmentsByTableAliasOrName(tableBinderContexts, boundedTableSegment.getAliasName().orElse("")), segment);
        }
    }

    @Generated
    private ShorthandProjectionSegmentBinder() {
    }
}

