/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.aware.CursorDefinition;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;

public final class CursorStatementContext
extends CommonSQLStatementContext
implements CursorAvailable,
TableAvailable,
WhereAvailable,
CursorDefinition {
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();
    private final TablesContext tablesContext = new TablesContext(this.getSimpleTableSegments(), this.getDatabaseType());
    private final SelectStatementContext selectStatementContext;

    public CursorStatementContext(ShardingSphereMetaData metaData, List<Object> params, OpenGaussCursorStatement sqlStatement, String defaultDatabaseName) {
        super((SQLStatement)sqlStatement);
        this.selectStatementContext = new SelectStatementContext(metaData, params, sqlStatement.getSelect(), defaultDatabaseName);
        this.whereSegments.addAll(this.selectStatementContext.getWhereSegments());
        this.columnSegments.addAll(this.selectStatementContext.getColumnSegments());
        this.joinConditions.addAll(this.selectStatementContext.getJoinConditions());
    }

    private Collection<SimpleTableSegment> getSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect(this.getSqlStatement().getSelect());
        return tableExtractor.getRewriteTables();
    }

    public OpenGaussCursorStatement getSqlStatement() {
        return (OpenGaussCursorStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getSimpleTableSegments();
    }

    @Override
    public Optional<CursorNameSegment> getCursorName() {
        return Optional.of(this.getSqlStatement().getCursorName());
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public SelectStatementContext getSelectStatementContext() {
        return this.selectStatementContext;
    }
}

