/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.util;

import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.oracle.type.OracleDatabaseType;
import org.apache.shardingsphere.infra.database.postgresql.type.PostgreSQLDatabaseType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ProjectionUtils {
    public static String getColumnLabelFromAlias(IdentifierValue alias, DatabaseType databaseType) {
        return ProjectionUtils.getIdentifierValueByDatabaseType(alias, databaseType);
    }

    private static String getIdentifierValueByDatabaseType(IdentifierValue identifierValue, DatabaseType databaseType) {
        if (QuoteCharacter.NONE != identifierValue.getQuoteCharacter()) {
            return identifierValue.getValue();
        }
        if (databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) {
            return identifierValue.getValue().toLowerCase();
        }
        if (databaseType instanceof OracleDatabaseType) {
            return identifierValue.getValue().toUpperCase();
        }
        return identifierValue.getValue();
    }

    public static String getColumnNameFromColumn(IdentifierValue columnName, DatabaseType databaseType) {
        return ProjectionUtils.getIdentifierValueByDatabaseType(columnName, databaseType);
    }

    public static String getColumnNameFromFunction(String functionName, String functionExpression, DatabaseType databaseType) {
        if (databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) {
            return functionName.toLowerCase();
        }
        if (databaseType instanceof OracleDatabaseType) {
            return functionExpression.replace(" ", "").toUpperCase();
        }
        return functionExpression;
    }

    public static String getColumnNameFromExpression(String expression, DatabaseType databaseType) {
        if (databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) {
            return "?column?";
        }
        if (databaseType instanceof OracleDatabaseType) {
            return expression.replace(" ", "").toUpperCase();
        }
        return expression;
    }

    public static String getColumnNameFromSubquery(SubqueryProjectionSegment subquerySegment, DatabaseType databaseType) {
        if (databaseType instanceof OracleDatabaseType) {
            return subquerySegment.getText().replace(" ", "").toUpperCase();
        }
        return subquerySegment.getText();
    }

    @Generated
    private ProjectionUtils() {
    }
}

