/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.engine;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class GeneratedKeyContextEngine {
    private final InsertStatement insertStatement;
    private final ShardingSphereSchema schema;

    public Optional<GeneratedKeyContext> createGenerateKeyContext(List<String> insertColumnNames, List<InsertValueContext> insertValueContexts, List<Object> params) {
        String tableName = Optional.ofNullable(this.insertStatement.getTable()).map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        return this.findGenerateKeyColumn(tableName).map(optional -> this.containsGenerateKey(insertColumnNames, (String)optional) ? this.findGeneratedKey(insertColumnNames, insertValueContexts, params, (String)optional) : new GeneratedKeyContext((String)optional, true));
    }

    private Optional<String> findGenerateKeyColumn(String tableName) {
        if (!this.schema.containsTable(tableName)) {
            return Optional.empty();
        }
        for (ShardingSphereColumn each : this.schema.getTable(tableName).getColumnValues()) {
            if (!each.isGenerated()) continue;
            return Optional.of(each.getName());
        }
        return Optional.empty();
    }

    private boolean containsGenerateKey(List<String> insertColumnNames, String generateKeyColumnName) {
        return insertColumnNames.isEmpty() ? this.schema.getVisibleColumnNames(this.insertStatement.getTable().getTableName().getIdentifier().getValue()).size() == this.getValueCountForPerGroup() : new CaseInsensitiveSet(insertColumnNames).contains((Object)generateKeyColumnName);
    }

    private int getValueCountForPerGroup() {
        if (!this.insertStatement.getValues().isEmpty()) {
            return ((InsertValuesSegment)this.insertStatement.getValues().iterator().next()).getValues().size();
        }
        Optional setAssignment = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)this.insertStatement);
        if (setAssignment.isPresent()) {
            return ((SetAssignmentSegment)setAssignment.get()).getAssignments().size();
        }
        if (this.insertStatement.getInsertSelect().isPresent()) {
            return ((SubquerySegment)this.insertStatement.getInsertSelect().get()).getSelect().getProjections().getProjections().size();
        }
        return 0;
    }

    private GeneratedKeyContext findGeneratedKey(List<String> insertColumnNames, List<InsertValueContext> insertValueContexts, List<Object> params, String generateKeyColumnName) {
        GeneratedKeyContext result = new GeneratedKeyContext(generateKeyColumnName, false);
        for (InsertValueContext each : insertValueContexts) {
            ExpressionSegment expression = each.getValueExpressions().get(this.findGenerateKeyIndex(insertColumnNames, generateKeyColumnName.toLowerCase()));
            if (expression instanceof ParameterMarkerExpressionSegment) {
                if (params.isEmpty() || null == params.get(((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex())) continue;
                result.getGeneratedValues().add((Comparable)params.get(((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex()));
                continue;
            }
            if (!(expression instanceof LiteralExpressionSegment)) continue;
            result.getGeneratedValues().add((Comparable)((LiteralExpressionSegment)expression).getLiterals());
        }
        return result;
    }

    private int findGenerateKeyIndex(List<String> insertColumnNames, String generateKeyColumnName) {
        return insertColumnNames.isEmpty() ? this.schema.getVisibleColumnNames(this.insertStatement.getTable().getTableName().getIdentifier().getValue()).indexOf(generateKeyColumnName) : insertColumnNames.indexOf(generateKeyColumnName);
    }

    @Generated
    public GeneratedKeyContextEngine(InsertStatement insertStatement, ShardingSphereSchema schema) {
        this.insertStatement = insertStatement;
        this.schema = schema;
    }
}

