/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class CreateTableStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable,
ConstraintAvailable {
    private final TablesContext tablesContext;

    public CreateTableStatementContext(CreateTableStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable(), this.getDatabaseType());
    }

    public CreateTableStatement getSqlStatement() {
        return (CreateTableStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(this.getSqlStatement().getTable());
        for (ColumnDefinitionSegment each : this.getSqlStatement().getColumnDefinitions()) {
            result.addAll(each.getReferencedTables());
        }
        for (ColumnDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            if (!each.getReferencedTable().isPresent()) continue;
            result.add((SimpleTableSegment)each.getReferencedTable().get());
        }
        return result;
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        for (ConstraintDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            each.getIndexName().ifPresent(result::add);
        }
        return result;
    }

    @Override
    public Collection<ConstraintSegment> getConstraints() {
        LinkedList<ConstraintSegment> result = new LinkedList<ConstraintSegment>();
        for (ConstraintDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            each.getConstraintName().ifPresent(result::add);
        }
        return result;
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ConstraintDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            result.addAll(each.getIndexColumns());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

