/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class AlterIndexStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public AlterIndexStatementContext(AlterIndexStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        SimpleTableSegment simpleTableSegment = AlterIndexStatementHandler.getSimpleTableSegment((AlterIndexStatement)sqlStatement).orElse(null);
        this.tablesContext = new TablesContext(simpleTableSegment, this.getDatabaseType());
    }

    public AlterIndexStatement getSqlStatement() {
        return (AlterIndexStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        Optional simpleTableSegment = AlterIndexStatementHandler.getSimpleTableSegment((AlterIndexStatement)this.getSqlStatement());
        return simpleTableSegment.map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        if (this.getSqlStatement().getIndex().isPresent()) {
            result.add((IndexSegment)this.getSqlStatement().getIndex().get());
        }
        AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)this.getSqlStatement()).ifPresent(result::add);
        return result;
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        return Collections.emptyList();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

