/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement;

import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.OpenGaussStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.OracleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.SQL92Statement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.SQLServerStatement;

public abstract class CommonSQLStatementContext
implements SQLStatementContext {
    private final SQLStatement sqlStatement;
    private final TablesContext tablesContext;
    private final DatabaseType databaseType;

    protected CommonSQLStatementContext(SQLStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.databaseType = this.getDatabaseType(sqlStatement);
        this.tablesContext = new TablesContext(Collections.emptyList(), this.databaseType);
    }

    private DatabaseType getDatabaseType(SQLStatement sqlStatement) {
        if (sqlStatement instanceof MySQLStatement) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"MySQL");
        }
        if (sqlStatement instanceof PostgreSQLStatement) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"PostgreSQL");
        }
        if (sqlStatement instanceof OracleStatement) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"Oracle");
        }
        if (sqlStatement instanceof SQLServerStatement) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"SQLServer");
        }
        if (sqlStatement instanceof OpenGaussStatement) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"openGauss");
        }
        if (sqlStatement instanceof SQL92Statement) {
            return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (String)"SQL92");
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getName());
    }

    @Override
    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

