/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ShorthandProjection
implements Projection {
    private final String owner;
    private final Collection<Projection> actualColumns;

    @Override
    public String getExpression() {
        return Strings.isNullOrEmpty((String)this.owner) ? "*" : this.owner + ".*";
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.empty();
    }

    @Override
    public String getColumnLabel() {
        return "*";
    }

    public Optional<String> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public Collection<ColumnProjection> getColumnProjections() {
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        for (Projection each : this.actualColumns) {
            if (!(each instanceof ColumnProjection)) continue;
            result.add((ColumnProjection)each);
        }
        return result;
    }

    @Override
    public Projection cloneWithOwner(IdentifierValue ownerIdentifier) {
        return new ShorthandProjection(ownerIdentifier.getValue(), this.actualColumns);
    }

    @Generated
    public ShorthandProjection(String owner, Collection<Projection> actualColumns) {
        this.owner = owner;
        this.actualColumns = actualColumns;
    }

    @Generated
    public Collection<Projection> getActualColumns() {
        return this.actualColumns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShorthandProjection)) {
            return false;
        }
        ShorthandProjection other = (ShorthandProjection)o;
        Optional<String> this$owner = this.getOwner();
        Optional<String> other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Collection<Projection> this$actualColumns = this.getActualColumns();
        Collection<Projection> other$actualColumns = other.getActualColumns();
        return !(this$actualColumns == null ? other$actualColumns != null : !((Object)this$actualColumns).equals(other$actualColumns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Collection<Projection> $actualColumns = this.getActualColumns();
        result = result * 59 + ($actualColumns == null ? 43 : ((Object)$actualColumns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShorthandProjection(owner=" + this.getOwner() + ", actualColumns=" + this.getActualColumns() + ")";
    }
}

