/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.impl;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.sql.common.enums.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnProjection
implements Projection {
    private final IdentifierValue ownerIdentifier;
    private final IdentifierValue nameIdentifier;
    private final IdentifierValue aliasIdentifier;

    public ColumnProjection(String owner, String name, String alias) {
        this(null == owner ? null : new IdentifierValue(owner, QuoteCharacter.NONE), new IdentifierValue(name, QuoteCharacter.NONE), null == alias ? null : new IdentifierValue(alias, QuoteCharacter.NONE));
    }

    public String getName() {
        return this.nameIdentifier.getValue();
    }

    public String getOwner() {
        return null == this.ownerIdentifier ? null : this.ownerIdentifier.getValue();
    }

    @Override
    public String getExpression() {
        return null == this.getOwner() ? this.getName() : this.getOwner() + "." + this.getName();
    }

    @Override
    public String getColumnLabel() {
        return this.getAlias().orElse(this.getName());
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.aliasIdentifier).map(IdentifierValue::getValue);
    }

    @Override
    public Projection cloneWithOwner(IdentifierValue ownerIdentifier) {
        return new ColumnProjection(ownerIdentifier, this.nameIdentifier, this.aliasIdentifier);
    }

    @Generated
    public ColumnProjection(IdentifierValue ownerIdentifier, IdentifierValue nameIdentifier, IdentifierValue aliasIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        this.nameIdentifier = nameIdentifier;
        this.aliasIdentifier = aliasIdentifier;
    }

    @Generated
    public IdentifierValue getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @Generated
    public IdentifierValue getNameIdentifier() {
        return this.nameIdentifier;
    }

    @Generated
    public IdentifierValue getAliasIdentifier() {
        return this.aliasIdentifier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnProjection)) {
            return false;
        }
        ColumnProjection other = (ColumnProjection)o;
        IdentifierValue this$ownerIdentifier = this.getOwnerIdentifier();
        IdentifierValue other$ownerIdentifier = other.getOwnerIdentifier();
        if (this$ownerIdentifier == null ? other$ownerIdentifier != null : !this$ownerIdentifier.equals(other$ownerIdentifier)) {
            return false;
        }
        IdentifierValue this$nameIdentifier = this.getNameIdentifier();
        IdentifierValue other$nameIdentifier = other.getNameIdentifier();
        if (this$nameIdentifier == null ? other$nameIdentifier != null : !this$nameIdentifier.equals(other$nameIdentifier)) {
            return false;
        }
        IdentifierValue this$aliasIdentifier = this.getAliasIdentifier();
        IdentifierValue other$aliasIdentifier = other.getAliasIdentifier();
        return !(this$aliasIdentifier == null ? other$aliasIdentifier != null : !this$aliasIdentifier.equals(other$aliasIdentifier));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdentifierValue $ownerIdentifier = this.getOwnerIdentifier();
        result = result * 59 + ($ownerIdentifier == null ? 43 : $ownerIdentifier.hashCode());
        IdentifierValue $nameIdentifier = this.getNameIdentifier();
        result = result * 59 + ($nameIdentifier == null ? 43 : $nameIdentifier.hashCode());
        IdentifierValue $aliasIdentifier = this.getAliasIdentifier();
        result = result * 59 + ($aliasIdentifier == null ? 43 : $aliasIdentifier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ColumnProjection(ownerIdentifier=" + this.getOwnerIdentifier() + ", nameIdentifier=" + this.getNameIdentifier() + ", aliasIdentifier=" + this.getAliasIdentifier() + ")";
    }
}

