/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.insert.values;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtils;

public final class InsertValueContext {
    private final int parameterCount;
    private final List<ExpressionSegment> valueExpressions;
    private final List<ParameterMarkerExpressionSegment> parameterMarkerExpressions;
    private final List<Object> parameters;

    public InsertValueContext(Collection<ExpressionSegment> assignments, List<Object> params, int parametersOffset) {
        this.valueExpressions = this.getValueExpressions(assignments);
        this.parameterMarkerExpressions = ExpressionExtractUtils.getParameterMarkerExpressions(assignments);
        this.parameterCount = this.parameterMarkerExpressions.size();
        this.parameters = this.getParameters(params, parametersOffset);
    }

    private List<ExpressionSegment> getValueExpressions(Collection<ExpressionSegment> assignments) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(assignments.size());
        result.addAll(assignments);
        return result;
    }

    private List<Object> getParameters(List<Object> params, int paramsOffset) {
        if (params.isEmpty() || 0 == this.parameterCount) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.parameterCount);
        result.addAll(params.subList(paramsOffset, paramsOffset + this.parameterCount));
        return result;
    }

    public Optional<Object> getLiteralValue(int index) {
        ExpressionSegment valueExpression = this.valueExpressions.get(index);
        if (valueExpression instanceof ParameterMarkerExpressionSegment) {
            return Optional.ofNullable(this.parameters.get(this.getParameterIndex((ParameterMarkerExpressionSegment)valueExpression)));
        }
        if (valueExpression instanceof LiteralExpressionSegment) {
            return Optional.ofNullable(((LiteralExpressionSegment)valueExpression).getLiterals());
        }
        return Optional.empty();
    }

    private int getParameterIndex(ParameterMarkerExpressionSegment paramMarkerExpression) {
        int result = this.parameterMarkerExpressions.indexOf(paramMarkerExpression);
        Preconditions.checkArgument((result >= 0 ? 1 : 0) != 0, (Object)"Can not get parameter index.");
        return result;
    }

    public int getParameterIndex(int index) {
        ExpressionSegment valueExpression = this.valueExpressions.get(index);
        return valueExpression instanceof ParameterMarkerExpressionSegment ? this.getParameterIndex((ParameterMarkerExpressionSegment)valueExpression) : -1;
    }

    @Generated
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Generated
    public List<ExpressionSegment> getValueExpressions() {
        return this.valueExpressions;
    }

    @Generated
    public List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions() {
        return this.parameterMarkerExpressions;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public String toString() {
        return "InsertValueContext(parameterCount=" + this.getParameterCount() + ", valueExpressions=" + this.getValueExpressions() + ", parameterMarkerExpressions=" + this.getParameterMarkerExpressions() + ", parameters=" + this.getParameters() + ")";
    }
}

