/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.exception.SchemaNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.sql.common.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.JoinType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class ProjectionEngine {
    private final String databaseName;
    private final Map<String, ShardingSphereSchema> schemas;
    private final DatabaseType databaseType;
    private int aggregationAverageDerivedColumnCount;
    private int aggregationDistinctDerivedColumnCount;

    public Optional<Projection> createProjection(TableSegment table, ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            return Optional.of(this.createProjection(table, (ShorthandProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return Optional.of(this.createProjection((ColumnProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ExpressionProjectionSegment) {
            return Optional.of(this.createProjection((ExpressionProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationDistinctProjectionSegment) {
            return Optional.of(this.createProjection((AggregationDistinctProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationProjectionSegment) {
            return Optional.of(this.createProjection((AggregationProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof SubqueryProjectionSegment) {
            return Optional.of(this.createProjection((SubqueryProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.createProjection((ParameterMarkerExpressionSegment)projectionSegment));
        }
        return Optional.empty();
    }

    private ParameterMarkerProjection createProjection(ParameterMarkerExpressionSegment projectionSegment) {
        return new ParameterMarkerProjection(projectionSegment.getParameterMarkerIndex(), projectionSegment.getParameterMarkerType(), projectionSegment.getAlias().orElse(null));
    }

    private SubqueryProjection createProjection(SubqueryProjectionSegment projectionSegment) {
        return new SubqueryProjection(projectionSegment.getText(), projectionSegment.getAlias().orElse(null));
    }

    private ShorthandProjection createProjection(TableSegment table, ShorthandProjectionSegment projectionSegment) {
        String owner = projectionSegment.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(null);
        LinkedHashSet<Projection> projections = new LinkedHashSet<Projection>();
        projections.addAll(this.getShorthandColumnsFromSimpleTableSegment(table, owner));
        projections.addAll(this.getShorthandColumnsFromSubqueryTableSegment(table));
        projections.addAll(this.getShorthandColumnsFromJoinTableSegment(table, owner, (ProjectionSegment)projectionSegment));
        return new ShorthandProjection(owner, projections);
    }

    private ColumnProjection createProjection(ColumnProjectionSegment projectionSegment) {
        String owner = projectionSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)projectionSegment.getColumn().getOwner().get()).getIdentifier().getValue() : null;
        return new ColumnProjection(owner, projectionSegment.getColumn().getIdentifier().getValue(), projectionSegment.getAlias().orElse(null));
    }

    private ExpressionProjection createProjection(ExpressionProjectionSegment projectionSegment) {
        return new ExpressionProjection(projectionSegment.getText(), projectionSegment.getAlias().orElse(null));
    }

    private AggregationDistinctProjection createProjection(AggregationDistinctProjectionSegment projectionSegment) {
        String innerExpression = projectionSegment.getInnerExpression();
        String alias = projectionSegment.getAlias().orElseGet(() -> DerivedColumn.AGGREGATION_DISTINCT_DERIVED.getDerivedColumnAlias(this.aggregationDistinctDerivedColumnCount++));
        AggregationDistinctProjection result = new AggregationDistinctProjection(projectionSegment.getStartIndex(), projectionSegment.getStopIndex(), projectionSegment.getType(), innerExpression, alias, projectionSegment.getDistinctExpression(), this.databaseType);
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDistinctDerivedProjection(result);
        }
        return result;
    }

    private AggregationProjection createProjection(AggregationProjectionSegment projectionSegment) {
        String innerExpression = projectionSegment.getInnerExpression();
        AggregationProjection result = new AggregationProjection(projectionSegment.getType(), innerExpression, projectionSegment.getAlias().orElse(null), this.databaseType);
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDerivedProjection(result);
        }
        return result;
    }

    private Collection<ColumnProjection> getShorthandColumnsFromSimpleTableSegment(TableSegment table, String owner) {
        if (!(table instanceof SimpleTableSegment)) {
            return Collections.emptyList();
        }
        String tableName = ((SimpleTableSegment)table).getTableName().getIdentifier().getValue();
        String tableAlias = table.getAlias().orElse(tableName);
        String schemaName = ((SimpleTableSegment)table).getOwner().map(optional -> optional.getIdentifier().getValue()).orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.databaseType, (String)this.databaseName)).toLowerCase();
        ShardingSphereSchema schema = this.schemas.get(schemaName);
        ShardingSpherePreconditions.checkNotNull((Object)schema, () -> new SchemaNotFoundException(schemaName));
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        if (null == owner) {
            schema.getVisibleColumnNames(tableName).stream().map(each -> new ColumnProjection(tableAlias, (String)each, null)).forEach(result::add);
        } else if (owner.equalsIgnoreCase(tableAlias)) {
            schema.getVisibleColumnNames(tableName).stream().map(each -> new ColumnProjection(owner, (String)each, null)).forEach(result::add);
        }
        return result;
    }

    private Collection<Projection> getShorthandColumnsFromSubqueryTableSegment(TableSegment table) {
        if (!(table instanceof SubqueryTableSegment)) {
            return Collections.emptyList();
        }
        SelectStatement subSelectStatement = ((SubqueryTableSegment)table).getSubquery().getSelect();
        Collection projections = subSelectStatement.getProjections().getProjections().stream().map(each -> this.createProjection(subSelectStatement.getFrom(), (ProjectionSegment)each).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        return this.getActualProjections(projections);
    }

    private Collection<Projection> getShorthandColumnsFromJoinTableSegment(TableSegment table, String owner, ProjectionSegment projectionSegment) {
        if (!(table instanceof JoinTableSegment)) {
            return Collections.emptyList();
        }
        JoinTableSegment joinTable = (JoinTableSegment)table;
        LinkedList<Projection> result = new LinkedList<Projection>();
        LinkedList<Projection> remainingProjections = new LinkedList<Projection>();
        for (Projection each : this.getOriginalProjections(joinTable, projectionSegment)) {
            Collection<Projection> actualProjections = this.getActualProjections(Collections.singletonList(each));
            if (joinTable.getUsing().isEmpty() && !joinTable.isNatural() || null != owner && each.getExpression().contains(owner)) {
                result.addAll(actualProjections);
                continue;
            }
            remainingProjections.addAll(actualProjections);
        }
        result.addAll(this.getUsingActualProjections(remainingProjections, joinTable.getUsing(), joinTable.isNatural()));
        return result;
    }

    private Collection<Projection> getOriginalProjections(JoinTableSegment joinTable, ProjectionSegment projectionSegment) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        if (this.databaseType instanceof MySQLDatabaseType && (!joinTable.getUsing().isEmpty() || joinTable.isNatural()) && JoinType.RIGHT.name().equalsIgnoreCase(joinTable.getJoinType())) {
            this.createProjection(joinTable.getRight(), projectionSegment).ifPresent(result::add);
            this.createProjection(joinTable.getLeft(), projectionSegment).ifPresent(result::add);
            return result;
        }
        this.createProjection(joinTable.getLeft(), projectionSegment).ifPresent(result::add);
        this.createProjection(joinTable.getRight(), projectionSegment).ifPresent(result::add);
        return result;
    }

    private Collection<Projection> getActualProjections(Collection<Projection> projections) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (Projection each : projections) {
            if (each instanceof ColumnProjection) {
                result.add(each);
                continue;
            }
            if (each instanceof ExpressionProjection) {
                result.add(each);
                continue;
            }
            if (!(each instanceof ShorthandProjection)) continue;
            result.addAll(((ShorthandProjection)each).getActualColumns().values());
        }
        return result;
    }

    private Collection<Projection> getUsingActualProjections(Collection<Projection> actualProjections, Collection<ColumnSegment> usingColumns, boolean natural) {
        if (usingColumns.isEmpty() && !natural) {
            return Collections.emptyList();
        }
        Collection<String> usingColumnNames = usingColumns.isEmpty() ? this.getUsingColumnNamesByNaturalJoin(actualProjections) : this.getUsingColumnNames(usingColumns);
        LinkedList<Projection> result = new LinkedList<Projection>();
        if (this.databaseType instanceof MySQLDatabaseType) {
            result.addAll(this.getJoinUsingColumnsByOriginalColumnSequence(actualProjections, usingColumnNames));
        } else {
            result.addAll(this.getJoinUsingColumnsByUsingColumnSequence(actualProjections, usingColumnNames));
        }
        result.addAll(this.getRemainingColumns(actualProjections, usingColumnNames));
        return result;
    }

    private Collection<String> getUsingColumnNamesByNaturalJoin(Collection<Projection> actualProjections) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LinkedHashMap<String, Projection> uniqueProjections = new LinkedHashMap<String, Projection>(actualProjections.size(), 1.0f);
        for (Projection each : actualProjections) {
            Projection previousProjection = uniqueProjections.put(each.getColumnLabel().toLowerCase(), each);
            if (null == previousProjection) continue;
            result.add(previousProjection.getColumnLabel().toLowerCase());
        }
        return result;
    }

    private Collection<String> getUsingColumnNames(Collection<ColumnSegment> usingColumns) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ColumnSegment each : usingColumns) {
            result.add(each.getIdentifier().getValue().toLowerCase());
        }
        return result;
    }

    private Collection<Projection> getJoinUsingColumnsByOriginalColumnSequence(Collection<Projection> actualProjections, Collection<String> usingColumnNames) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (Projection each : actualProjections) {
            if (result.size() == usingColumnNames.size()) {
                return result;
            }
            if (!usingColumnNames.contains(each.getColumnLabel().toLowerCase())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<Projection> getJoinUsingColumnsByUsingColumnSequence(Collection<Projection> actualProjections, Collection<String> usingColumnNames) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        block0: for (String each : usingColumnNames) {
            for (Projection projection : actualProjections) {
                if (!each.equals(projection.getColumnLabel().toLowerCase())) continue;
                result.add(projection);
                continue block0;
            }
        }
        return result;
    }

    private Collection<Projection> getRemainingColumns(Collection<Projection> actualProjections, Collection<String> usingColumnNames) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (Projection each : actualProjections) {
            if (usingColumnNames.contains(each.getColumnLabel().toLowerCase())) continue;
            result.add(each);
        }
        return result;
    }

    private void appendAverageDistinctDerivedProjection(AggregationDistinctProjection averageDistinctProjection) {
        String innerExpression = averageDistinctProjection.getInnerExpression();
        String distinctInnerExpression = averageDistinctProjection.getDistinctInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection countDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.COUNT, innerExpression, countAlias, distinctInnerExpression, this.databaseType);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection sumDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.SUM, innerExpression, sumAlias, distinctInnerExpression, this.databaseType);
        averageDistinctProjection.getDerivedAggregationProjections().add(countDistinctProjection);
        averageDistinctProjection.getDerivedAggregationProjections().add(sumDistinctProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    private void appendAverageDerivedProjection(AggregationProjection averageProjection) {
        String innerExpression = averageProjection.getInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection countProjection = new AggregationProjection(AggregationType.COUNT, innerExpression, countAlias, this.databaseType);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection sumProjection = new AggregationProjection(AggregationType.SUM, innerExpression, sumAlias, this.databaseType);
        averageProjection.getDerivedAggregationProjections().add(countProjection);
        averageProjection.getDerivedAggregationProjections().add(sumProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    @Generated
    public ProjectionEngine(String databaseName, Map<String, ShardingSphereSchema> schemas, DatabaseType databaseType) {
        this.databaseName = databaseName;
        this.schemas = schemas;
        this.databaseType = databaseType;
    }
}

