/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class ProjectionEngine {
    private final ShardingSphereSchema schema;
    private int aggregationAverageDerivedColumnCount;
    private int aggregationDistinctDerivedColumnCount;

    public Optional<Projection> createProjection(Collection<SimpleTableSegment> tableSegments, ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            return Optional.of(this.createProjection(tableSegments, (ShorthandProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return Optional.of(this.createProjection((ColumnProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof ExpressionProjectionSegment) {
            return Optional.of(this.createProjection((ExpressionProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationDistinctProjectionSegment) {
            return Optional.of(this.createProjection((AggregationDistinctProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof AggregationProjectionSegment) {
            return Optional.of(this.createProjection((AggregationProjectionSegment)projectionSegment));
        }
        if (projectionSegment instanceof SubqueryProjectionSegment) {
            return Optional.of(this.createProjection((SubqueryProjectionSegment)projectionSegment));
        }
        return Optional.empty();
    }

    private SubqueryProjection createProjection(SubqueryProjectionSegment projectionSegment) {
        return new SubqueryProjection(projectionSegment.getText(), projectionSegment.getAlias().orElse(null));
    }

    private ShorthandProjection createProjection(Collection<SimpleTableSegment> tableSegments, ShorthandProjectionSegment projectionSegment) {
        String owner = projectionSegment.getOwner().map(ownerSegment -> ownerSegment.getIdentifier().getValue()).orElse(null);
        Collection<ColumnProjection> shorthandColumns = this.getShorthandColumns(tableSegments, owner);
        return new ShorthandProjection(owner, shorthandColumns);
    }

    private ColumnProjection createProjection(ColumnProjectionSegment projectionSegment) {
        String owner = projectionSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)projectionSegment.getColumn().getOwner().get()).getIdentifier().getValue() : null;
        return new ColumnProjection(owner, projectionSegment.getColumn().getIdentifier().getValue(), projectionSegment.getAlias().orElse(null));
    }

    private ExpressionProjection createProjection(ExpressionProjectionSegment projectionSegment) {
        return new ExpressionProjection(projectionSegment.getText(), projectionSegment.getAlias().orElse(null));
    }

    private AggregationDistinctProjection createProjection(AggregationDistinctProjectionSegment projectionSegment) {
        String innerExpression = projectionSegment.getInnerExpression();
        String alias = projectionSegment.getAlias().orElse(DerivedColumn.AGGREGATION_DISTINCT_DERIVED.getDerivedColumnAlias(this.aggregationDistinctDerivedColumnCount++));
        AggregationDistinctProjection result = new AggregationDistinctProjection(projectionSegment.getStartIndex(), projectionSegment.getStopIndex(), projectionSegment.getType(), innerExpression, alias, projectionSegment.getDistinctExpression());
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDistinctDerivedProjection(result);
        }
        return result;
    }

    private AggregationProjection createProjection(AggregationProjectionSegment projectionSegment) {
        String innerExpression = projectionSegment.getInnerExpression();
        AggregationProjection result = new AggregationProjection(projectionSegment.getType(), innerExpression, projectionSegment.getAlias().orElse(null));
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDerivedProjection(result);
        }
        return result;
    }

    private Collection<ColumnProjection> getShorthandColumns(Collection<SimpleTableSegment> tables, String owner) {
        return null == owner ? this.getUnqualifiedShorthandColumns(tables) : this.getQualifiedShorthandColumns(tables, owner);
    }

    private Collection<ColumnProjection> getUnqualifiedShorthandColumns(Collection<SimpleTableSegment> tables) {
        LinkedHashSet<ColumnProjection> result = new LinkedHashSet<ColumnProjection>();
        for (SimpleTableSegment each : tables) {
            String owner = each.getAlias().orElse(each.getTableName().getIdentifier().getValue());
            result.addAll(this.schema.getAllColumnNames(each.getTableName().getIdentifier().getValue()).stream().map(columnName -> new ColumnProjection(owner, (String)columnName, null)).collect(Collectors.toList()));
        }
        return result;
    }

    private Collection<ColumnProjection> getQualifiedShorthandColumns(Collection<SimpleTableSegment> tables, String owner) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!owner.equalsIgnoreCase(each.getAlias().orElse(tableName))) continue;
            return this.schema.getAllColumnNames(tableName).stream().map(columnName -> new ColumnProjection(owner, (String)columnName, null)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isMatch(ShorthandProjectionSegment projectionSegment, SimpleTableSegment tableSegment) {
        return !projectionSegment.getOwner().isPresent() || tableSegment.getAlias().orElse(tableSegment.getTableName().getIdentifier().getValue()).equals(((OwnerSegment)projectionSegment.getOwner().get()).getIdentifier().getValue());
    }

    private void appendAverageDistinctDerivedProjection(AggregationDistinctProjection averageDistinctProjection) {
        String innerExpression = averageDistinctProjection.getInnerExpression();
        String distinctInnerExpression = averageDistinctProjection.getDistinctInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection countDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.COUNT, innerExpression, countAlias, distinctInnerExpression);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection sumDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.SUM, innerExpression, sumAlias, distinctInnerExpression);
        averageDistinctProjection.getDerivedAggregationProjections().add(countDistinctProjection);
        averageDistinctProjection.getDerivedAggregationProjections().add(sumDistinctProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    private void appendAverageDerivedProjection(AggregationProjection averageProjection) {
        String innerExpression = averageProjection.getInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection countProjection = new AggregationProjection(AggregationType.COUNT, innerExpression, countAlias);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection sumProjection = new AggregationProjection(AggregationType.SUM, innerExpression, sumAlias);
        averageProjection.getDerivedAggregationProjections().add(countProjection);
        averageProjection.getDerivedAggregationProjections().add(sumProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    @Generated
    public ProjectionEngine(ShardingSphereSchema schema) {
        this.schema = schema;
    }
}

