/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.having.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.select.having.HavingColumn;
import org.apache.shardingsphere.infra.binder.segment.select.having.HavingContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class HavingContextEngine {
    public HavingContext createHavingContext(SelectStatement selectStatement) {
        Optional havingSegment = selectStatement.getHaving();
        if (!havingSegment.isPresent()) {
            return new HavingContext(null, false, new LinkedList<HavingColumn>());
        }
        LinkedList<HavingColumn> columns = new LinkedList<HavingColumn>();
        ExpressionSegment segment = ((HavingSegment)havingSegment.get()).getExpr();
        this.extractHavingColumn(segment, columns);
        String havingExpression = segment instanceof BinaryOperationExpression ? ((BinaryOperationExpression)segment).getText() : "";
        return new HavingContext(havingExpression, !columns.isEmpty(), columns);
    }

    private void extractHavingColumn(ExpressionSegment expression, Collection<HavingColumn> columns) {
        if (expression instanceof BinaryOperationExpression) {
            this.extractHavingColumnFromBinaryOperationExpression(((BinaryOperationExpression)expression).getLeft(), columns);
            this.extractHavingColumnFromBinaryOperationExpression(((BinaryOperationExpression)expression).getRight(), columns);
        }
    }

    private void extractHavingColumnFromBinaryOperationExpression(ExpressionSegment expression, Collection<HavingColumn> columns) {
        if (expression instanceof BinaryOperationExpression) {
            this.extractHavingColumn(expression, columns);
        }
        if (expression instanceof AggregationProjectionSegment) {
            this.extractHavingColumnFromAggregationProjectionSegment((AggregationProjectionSegment)expression, columns);
        }
        if (expression instanceof ExpressionProjectionSegment) {
            this.extractHavingColumnFromExpressionProjectionSegment((ExpressionProjectionSegment)expression, columns);
        }
        if (expression instanceof ColumnSegment) {
            this.extractHavingColumnFromColumnSegment((ColumnSegment)expression, columns);
        }
    }

    private void extractHavingColumnFromColumnSegment(ColumnSegment segment, Collection<HavingColumn> columns) {
        columns.add(new HavingColumn(segment));
    }

    private void extractHavingColumnFromExpressionProjectionSegment(ExpressionProjectionSegment segment, Collection<HavingColumn> columns) {
        columns.add(new HavingColumn(new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), new IdentifierValue(segment.getText()))));
    }

    private void extractHavingColumnFromAggregationProjectionSegment(AggregationProjectionSegment segment, Collection<HavingColumn> columns) {
        String columnLabel = SQLUtil.getExactlyValue((String)(segment.getType().name() + segment.getInnerExpression()));
        columns.add(new HavingColumn(new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), new IdentifierValue(columnLabel))));
    }
}

