/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.parser.core;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.EncryptDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.EncryptDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowPluginsStatement;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptColumnItemSegment;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptColumnSegment;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.statement.AlterEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.statement.CreateEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptDistSQLStatementVisitor
extends EncryptDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateEncryptRule(EncryptDistSQLStatementParser.CreateEncryptRuleContext ctx) {
        return new CreateEncryptRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterEncryptRule(EncryptDistSQLStatementParser.AlterEncryptRuleContext ctx) {
        return new AlterEncryptRuleStatement((Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropEncryptRule(EncryptDistSQLStatementParser.DropEncryptRuleContext ctx) {
        return new DropEncryptRuleStatement(null != ctx.ifExists(), (Collection)ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowEncryptRules(EncryptDistSQLStatementParser.ShowEncryptRulesContext ctx) {
        return new ShowEncryptRulesStatement(null == ctx.tableRule() ? null : this.getIdentifierValue((ParseTree)ctx.tableRule().tableName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitEncryptRuleDefinition(EncryptDistSQLStatementParser.EncryptRuleDefinitionContext ctx) {
        return new EncryptRuleSegment(this.getIdentifierValue((ParseTree)ctx.tableName()), (Collection)ctx.encryptTableRuleDefinition().encryptColumnDefinition().stream().map(each -> (EncryptColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitEncryptColumnDefinition(EncryptDistSQLStatementParser.EncryptColumnDefinitionContext ctx) {
        EncryptColumnItemSegment cipher = new EncryptColumnItemSegment(this.getIdentifierValue((ParseTree)ctx.cipherColumnDefinition().cipherColumnName()), (AlgorithmSegment)this.visit((ParseTree)ctx.encryptAlgorithm().algorithmDefinition()));
        EncryptColumnItemSegment assistedQuery = null == ctx.assistedQueryColumnDefinition() ? null : new EncryptColumnItemSegment(this.getIdentifierValue((ParseTree)ctx.assistedQueryColumnDefinition().assistedQueryColumnName()), this.getAssistedEncryptor(ctx));
        EncryptColumnItemSegment likeQuery = null == ctx.likeQueryColumnDefinition() ? null : new EncryptColumnItemSegment(this.getIdentifierValue((ParseTree)ctx.likeQueryColumnDefinition().likeQueryColumnName()), this.getLikeEncryptor(ctx));
        return new EncryptColumnSegment(this.getIdentifierValue((ParseTree)ctx.columnDefinition().columnName()), cipher, assistedQuery, likeQuery);
    }

    private AlgorithmSegment getAssistedEncryptor(EncryptDistSQLStatementParser.EncryptColumnDefinitionContext ctx) {
        return null == ctx.assistedQueryAlgorithm() ? null : (AlgorithmSegment)this.visit((ParseTree)ctx.assistedQueryAlgorithm().algorithmDefinition());
    }

    private AlgorithmSegment getLikeEncryptor(EncryptDistSQLStatementParser.EncryptColumnDefinitionContext ctx) {
        return null == ctx.likeQueryAlgorithm() ? null : (AlgorithmSegment)this.visit((ParseTree)ctx.likeQueryAlgorithm().algorithmDefinition());
    }

    @Override
    public ASTNode visitAlgorithmDefinition(EncryptDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    private Properties getProperties(EncryptDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (EncryptDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableName(EncryptDistSQLStatementParser.TableNameContext ctx) {
        return new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitDatabaseName(EncryptDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitCountEncryptRule(EncryptDistSQLStatementParser.CountEncryptRuleContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), "ENCRYPT");
    }

    @Override
    public ASTNode visitShowEncryptAlgorithmPlugins(EncryptDistSQLStatementParser.ShowEncryptAlgorithmPluginsContext ctx) {
        return new ShowPluginsStatement("ENCRYPT_ALGORITHM");
    }
}

